<?php

/**
 * Contact shortcode
 */
class ctContactShortcode extends ctShortcode {


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Contact';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'contact';
    }

    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        $class = '';
        $shortcodeEmail = '';
        $shortcodePhone = '';

        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $mainContainerAtts = array(
            'class' => array(
                'row',
                $class
            ),
        );

        $arrayEmail = explode(",", $email);
        $arrayPhone = explode(",", $phone);

        if ($email != '') {
            $i = 0;
            $shortcodeEmail = '';
            foreach ($arrayEmail as $value) {
                $shortcodeEmail .= '[icon_text text="' . $value . '" email="true" icon="fa-envelope-o" link="' . $value . '"]';
            }
        }

        if ($phone != '') {
            $i = 0;
            $shortcodePhone = '';
            foreach ($arrayPhone as $value) {
                $shortcodePhone .= '[icon_text text="' . $value . '" email="false" icon="fa-phone"]';
            }
        }

        $map = $map_link ? '
            <span class="contacts-map">
            <a target="_blank" href="' . esc_url($map_link) . '"><i class="fa fa-map-marker"></i><br>' . $map_label . '</a>
            </span>' : '';

        $shortcodeContact = '
                <h4 class="widget-title">' . $title . '</h4>
                <div ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . '>
                    <div class="col-sm-6">
                        <div class="contacts">
                         ' . $address . '
                         <span class="contacts-map">' . $map . '</span>
                    </div></div>
                    <div class="col-sm-6">
                        <div class="contacts">
                    ' . $shortcodePhone . '
                    ' . $shortcodeEmail . '
                </div></div></div>
            ';


        return do_shortcode($shortcodeContact);
    }


    /**
     * Returns config
     *
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'title' => array('label' => __('Title', 'ct_theme'), 'default' => __('Contact us', 'ct_theme'), 'type' => 'input'),
            'widgetmode' => array('default' => 'false', 'type' => false),
            'phone' => array('label' => __('phone', 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __("enter phone number. separating items with a comma", 'ct_theme')),
            'email' => array('label' => __('email', 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __("enter email address. separating items with a comma", 'ct_theme')),
            'address' => array('label' => __('address', 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('type ' . htmlspecialchars('<br>') . ' to enter the next line', 'ct_theme')),
            'map_link' => array('label' => __('map link', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'map_label' => array('label' => __('Map label', 'ct_theme'), 'default' => __('map', 'ct_theme'), 'type' => 'input'));
    }


}

new ctContactShortcode();