<?php

/**
 * ct Daily Menu Shortcode
 */
class ctDailyMenu extends ctShortcodeQueryable {


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Daily Menu';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'Daily_menu';
    }

    /**
     * Returns shortcode type
     * @return mixed|string
     */

    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_ENCLOSING;
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $args = array(
            'title' => $title,
            'icon' => $image,
            'description' => $description
        );


        if ('today' == $day) {
            return ctMealPlan::getTodayMenuWidgetHTML($args);
        } elseif ('next' == $day) {
            return ctMealPlan::getNextDayMenuWidgetHTML($args);
        } elseif('custom'== $day) {
            return ctMealPlan::getCustomMenuWidgetHTML($custom_day_number, $args);
        }



    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'title' => array('label' => __('Title', 'ct_theme'), 'default' => 'Daily Menu', 'type' => 'input'),
            'description' => array('label' => __('Description', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'image' => array('label' => __("Image", 'ct_theme'), 'default' => '', 'type' => 'image', 'help' => __("Image source", 'ct_theme')),
            'day' => array('label' => __('Day', 'ct_theme'), 'default' => 'today', 'type' => 'select',
                'choices' => array('today' => __('today', 'ct_theme'), 'next' => __('next day', 'ct_theme'), 'custom' => __('custom day', 'ct_theme')), 'help' => __("Inline or block style", 'ct_theme')),
            'custom_day_number' => array('label' => __('Custom Day number (1-7)', 'ct_theme'), 'default' => '1', 'type' => 'input'),
        );
    }


}

new ctDailyMenu();