<?php

/**
 * ctMostCommented Shortcode
 */
class ctMostViewedShortcode extends ctShortcodeQueryable
{

    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Most Viewed';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'most_viewed';
    }

    /**
     * Returns shortcode type
     * @return mixed|string
     */

    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_ENCLOSING;
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));
        $this->addInlineJS($this->getInlineJS(), true);



        $recentposts = $this->getCollection(array('limit' => $limit), array('post_type' => 'post', 'orderby' => 'meta_value_num', 'meta_key'=>'post_view_count', 'order'=>'DESC', 'post_status'=>'publish'));

        $args = array(  'numberposts'  => $limit,  /* get 4 posts, or set -1 for all */
            'orderby'      => 'meta_value',  /* this will look at the meta_key you set below */
            'meta_key'     => 'post_view_count',
            'order'        => 'DESC',
            'post_type'    => 'post',
            'post_status'  => 'publish'
        );


        $items = array();
        $i = 0;
        $oldCount = 0;
        //var_dump($recentposts);
        foreach ($recentposts as $p) {
            $custom = get_post_custom($p->ID);
            $post_view_count = isset($custom["post_view_count"][0]) ? $custom["post_view_count"][0] : 0;


            //don't show duplicate values
            if ($post_view_count == $oldCount){
                continue;
            }

            if ($post_view_count == 0 || $post_view_count < $min_views) {
                break;
            }

            $items[$i]['link'] = get_permalink($p->ID);
            $items[$i]['title'] = get_the_title($p->ID);
            $items[$i]['timestamp_value'] = human_time_diff(strtotime($p->post_date), current_time('timestamp')) . ' ' . $ago_label;
            $items[$i]['list_quantity_value'] = $post_view_count;
            $items[$i]['tooltip_placement'] = 'left';
            $items[$i]['tooltip_title'] = $tooltip;
            $oldCount = $post_view_count;
            $i++;
        }


        $argsDefault = array(
            'main_container_height' => '165px',
            'icon_up_class' => 'fa fa-chevron-up',
            'icon_down_class' => 'fa fa-chevron-down',
            'ul_max_height' => '165px',
            'main_container_class' => '',
            'no_scroll' => false,
            'ul_class' => 'list-counter',
            'before_list' => '',
            'after_list' => '',
            'raw_content' => false,
            'before_item_global' => '<li>',
            'after_item_global' => '</li>'
        );

        if ($i < 2) {
            $argsDefault['no_scroll'] = true;
        }

        $formatter = new ctScrollBoxFormatter();
        return '<h4 class="color-motive uppercase">' . $title . '</h4>' . do_shortcode($formatter->format($items, $argsDefault));

    }


    /**
     * returns inline js
     * @param $attributes
     * @param $id
     * @return string
     */
    protected function getInlineJS()
    {
        return '

             /* ======================= */
    /* ==== WIDGET SCROLL ==== */

    jQuery(".with-scroll").each(function(){
        var $this = jQuery(this);

        $this.find("ul").css({
            "max-height": $this.data("height")
        });
        $this.find(".tweets_display ul").css({
            "max-height": $this.data("height")
        });

        var step = 100;
        var scrolling = false;

        // Wire up events for the "scrollUp" link:
        $this.find(".scrollUp").bind("click", function (event) {
            event.preventDefault();
            // Animates the scrollTop property by the specified
            // step.
            $this.find("ul").animate({
                scrollTop: "-=" + step + "px"
            });
        }).bind("mouseover", function (event) {
            scrolling = true;
            scrollContent("up");
        }).bind("mouseout", function (event) {
            scrolling = false;
        });


        $this.find(".scrollDown").bind("click", function (event) {
            event.preventDefault();
            $this.find("ul").animate({
                scrollTop: "+=" + step + "px"
            });
        }).bind("mouseover", function (event) {
            scrolling = true;
            scrollContent("down");
        }).bind("mouseout", function (event) {
            scrolling = false;
        });

        function scrollContent(direction) {
            var amount = (direction === "up" ? "-=3px" : "+=3px");
            $this.find("ul").animate({
                scrollTop: amount
            }, 1, function () {
                if (scrolling) {
                    scrollContent(direction);
                }
            });
        }
    });

        ';
    }
    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {

        return array(
            'title' => array('label' => __('Title', 'ct_theme'), 'default' => 'Most Viewed', 'type' => 'input'),
            'height' => array('label' => __('Height', 'ct_theme'), 'default' => '165px', 'type' => 'input'),
            'tooltip' => array('label' => __('Tooltip title', 'ct_theme'), 'default' => __('views','ct_theme'), 'type' => 'input'),
            'ago_label' => array('label' => __('Ago label', 'ct_theme'), 'default' => 'ago', 'type' => 'input'),
            'min_views' => array('label' => __('Minimum number of views ', 'ct_theme'), 'default' => '1', 'type' => 'input'),
            'limit' => array('label' => __('Limit posts in widget', 'ct_theme'), 'default' => '10', 'type' => 'input'),
        );
    }


}

new ctMostViewedShortcode();