<?php

/**
 * Opening hours shortcode
 */
class ctOpeningHoursShortcode extends ctShortcode
{

    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Opening Hours';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'opening_hours';
    }

    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $mainContainerAtts = array(
            'class' => array(
                $class
            ),
        );

        $icon = $image != '' ? '<div class="icon"><img src="' . $image . '" alt="'.__('icon','ct_theme').'"></div>' : '';
        $title = $title != '' ? '<h4 class="color-motive uppercase">' . $title . '</h4>' : '';

        return do_shortcode('<div ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . '>' . $icon . $title . '<table class="table"><tbody>' . $content . '</tbody></table></div>');
    }

    public function getChildShortcodeInfo()
    {
        return array('name' => 'opening_hours_item', 'min' => 5, 'max' => 20, 'default_qty' => 4);
    }

    /**
     * Returns config
     *
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'title' => array('label' => __('Title', 'ct_theme'), 'default' => __('Opening Hours', 'ct_theme'), 'type' => 'input'),
            'image' => array('label' => __("image", 'ct_theme'), 'default' => '', 'type' => 'image', 'help' => __("Image source", 'ct_theme')),
            'class' => array('label' => __("Custom class", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('Adding custom class allows you to set diverse styles in css to the element. Type in name of class, which you defined in css. You can add as much classes as you like.', 'ct_theme')),
        );
    }


}

new ctOpeningHoursShortcode();