<?php

/**
 * Opening hours item shortcode
 */
class ctOpeningHoursItemShortcode extends ctShortcode
{

    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Opening Hours Item';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'opening_hours_item';
    }


    public function getParentShortcodeName()
    {
        return '';
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        $class = '';
        $shortcodeEmail = '';
        $shortcodePhone = '';

        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));


        return do_shortcode('<tr>
                                <td>' . $day . '</td>
                                <td>' . $hours . '</td>
                            </tr>');
    }


    /**
     * Returns config
     *
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'day' => array('label' => __('Day', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'hours' => array('label' => __('Hours', 'ct_theme'), 'default' => '', 'type' => "input"),
        );
    }


}

new ctOpeningHoursItemShortcode();