<?php

/**
 * ctMostCommented Shortcode
 */
class ctSidePhotoGallery extends ctShortcodeQueryable
{

    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Side Photo Gallery';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'side_photo_gallery';
    }

    /**
     * Returns shortcode type
     * @return mixed|string
     */

    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_ENCLOSING;
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));


        $mainContainerAtts = array(
            'class' => array('sidebar-gallery'),
        );

        $html = '';
        if (is_numeric($gallery_id)) {
            $args = array(
                'post_type' => 'attachment',
                'numberposts' => -1,
                'post_status' => null,
                'post_parent' => $gallery_id
            );
        } else {
            return;
        }
        $counter = 0;
        $attachments = get_posts($args);

        if ($attachments) {
            $itemsArr = array();
            foreach ($attachments as $attach) {
                if ($counter == $limit) {
                    break;
                }
                $image_small = wp_get_attachment_image_src($attach->ID, 'sidebar_gallery');
                //$image_full = wp_get_attachment_image_src($attach->ID, 'full');
                $html .= '<a class="popup" data-type="image" href="' . get_permalink($attach->ID) . '"><img alt="'.__('block image','ct_theme').'" src="' . esc_url($image_small[0]) . '"></a>';
                $counter++;
                //var_dump($attach);
            }

        }

        $title = $title != '' ? '<h4 class="color-motive uppercase">' . $title . '</h4>' : '';
        $desc = $description != '' ? '<p>' . $description . '</p>' : '';

        $link = '';

        if(!empty($link_label)) {
            $link = '<a href="' . get_permalink($gallery_id) . '" class="color-motive-light">' . esc_html($link_label) . '</a>';
        }

        return $title . $desc . '<div ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . '>' . $html . '</div>' . $link;
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {

        $args = array(
            'post_type' => 'gallery',
            'numberposts' => -1,
            'post_status' => null,
        );
        $postArr = array();
        foreach (get_posts($args) as $post) {
            $postArr[$post->ID] = $post->post_name;
        }

        return array(
            'title' => array('label' => __('Title', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'description' => array('label' => __('Description', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'link_label' => array('label' => __('Link label', 'ct_theme'), 'default' => 'visit our gallery', 'type' => 'input'),
            'gallery_id' => array('label' => __('Gallery', 'ct_theme'), 'default' => '', 'type' => 'select', 'choices' => $postArr, 'help' => __('Select gallery.', 'ct_theme')),
            'limit' => array('label' => __('Limit images in widget', 'ct_theme'), 'default' => '4', 'type' => 'input'),
            'class' => array('label' => __("Custom class", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('Adding custom class allows you to set diverse styles in css to the element. Type in name of class, which you defined in css. You can add as much classes as you like.', 'ct_theme')),
        );
    }


}

new ctSidePhotoGallery();