<?php

/**
 * Recent posts
 * ver. 2.2
 */
class ctRecentPostsShortcode extends ctShortcodeQueryable implements ctVisualComposerShortcodeInterface{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Recent posts';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'recent_posts';
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */
    public function handle($atts, $content = null)
    {
        $attributes = shortcode_atts($this->extractShortcodeAttributes($atts), $atts);

        extract($attributes);
        $recentposts = $this->getCollection($attributes);
        if ($widgetmode == 'true') {
            $this->addInlineJS($this->getInlineJS(), true);
            //$title = ($title != '') ? '<h1 class="widget-title">' . $title . '</h1>' : '';
            $html = $title;
            $i = 0;
            $items = array();
            foreach ($recentposts as $p) {
                $postFormat = (get_post_format($p->ID));
                if ($widget_show_excerpt == 'show') {
                    $text = ct_get_excerpt_by_id($p->ID);
                } else {
                    $text = '';
                }
                if ($type == 'image') {

                    if ($postFormat == 'gallery') {
                        $picture = '<a class="" href="' . get_permalink($p) . '" >
                              [spacer height="10"][gallery_slider speed="2500" height="150" limit="100" size="widget_gallery" dircontrols="false" slideshow="true" ID="' . $p->ID . '"]
                             </a>';
                    } elseif (has_post_thumbnail($p->ID)) {
                        $picture = '<a class="" href="' . get_permalink($p) . '" >
                            ' . '<img style="padding-top:10px; padding-bottom:10px" src="' . esc_url(ct_get_feature_image_src($p->ID, 'widget_gallery')) . '" alt="'.__('recent post image','ct_theme').'">' . '
                             </a>';
                    } else {
                        $picture = '';                    }


                } else {
                    $picture = '';
                }
                $items[$i]['link'] = get_permalink($p->ID);
                $items[$i]['title'] = get_the_title($p->ID);
                $items[$i]['timestamp_value'] = strip_tags(ct_get_excerpt_by_id($p->ID, 10));
                $items[$i]['after_item'] = $picture;
                $i++;
            }


            $args = array(
                'main_container_height' => $height,
                'icon_up_class' => 'fa fa-chevron-up',
                'icon_down_class' => 'fa fa-chevron-down',
                'ul_max_height' => '220',
                'main_container_class' => '',
                'no_scroll' => false,
                'ul_class' => 'list-counter',
                'before_list' => '',
                'after_list' => '',
                'before_item' => '<li>',
                'after_item' => '</li>',
                'raw_content' => false
            );


            $formatter = new ctScrollBoxFormatter();
            return '<h4 class="color-motive uppercase">' . $title . '</h4>' . do_shortcode($formatter->format($items, $args));


        } else {
            $this->addInlineJS($this->getInlineJS(), true);
            $i = 0;
            $items = array();
            foreach ($recentposts as $p) {
                $postFormat = (get_post_format($p->ID));
                if ($widget_show_excerpt == 'show') {
                    $text = ct_get_excerpt_by_id($p->ID);
                } else {
                    $text = '';
                }
                if ($type == 'image') {
                    if ($postFormat == 'gallery') {
                        $picture = '<a class="" href="' . get_permalink($p) . '" >
                              [spacer height="10"][gallery_slider speed="2500" height="150" limit="100" size="widget_gallery" dircontrols="false" slideshow="true" ID="' . $p->ID . '"]
                             </a>';
                    } elseif (has_post_thumbnail($p->ID)) {
                        $picture = '<a class="" href="' . get_permalink($p) . '" >
                            ' . '<img style="padding-top:10px; padding-bottom:10px" src="' . esc_url(ct_get_feature_image_src($p->ID, 'widget_gallery')) . '" alt="'.__('recent post image','ct_theme').'">' . '
                             </a>';
                    } else {
                        $picture = '';
                    }
                } else {
                    $picture = '';
                }
                $items[$i]['link'] = get_permalink($p->ID);
                $items[$i]['title'] = get_the_title($p->ID);
                $items[$i]['timestamp_value'] = strip_tags(ct_get_excerpt_by_id($p->ID, 10));
                $items[$i]['after_item'] = $picture;
                $i++;
            }

            $args = array(
                'main_container_height' => $height,
                'icon_up_class' => 'fa fa-chevron-up',
                'icon_down_class' => 'fa fa-chevron-down',
                'ul_max_height' => '220',
                'main_container_class' => '',
                'no_scroll' => false,
                'ul_class' => 'list-counter',
                'before_list' => '',
                'after_list' => '',
                'before_item' => '<li>',
                'after_item' => '</li>',
                'raw_content' => false
            );


            $formatter = new ctScrollBoxFormatter();
            return '<div class="daycare-widget"><h4 class="color-motive uppercase">' . $title . '</h4>' . do_shortcode($formatter->format($items, $args)).'</div>';
        }
    }


    /**
     * returns inline js
     * @param $attributes
     * @param $id
     * @return string
     */
    protected function getInlineJS()
    {
        return '

             /* ======================= */
    /* ==== WIDGET SCROLL ==== */

    jQuery(".with-scroll").each(function(){
        var $this = jQuery(this);

        $this.find("ul").css({
            "max-height": $this.data("height")
        });
        $this.find(".tweets_display ul").css({
            "max-height": $this.data("height")
        });

        var step = 100;
        var scrolling = false;

        // Wire up events for the "scrollUp" link:
        $this.find(".scrollUp").bind("click", function (event) {
            event.preventDefault();
            // Animates the scrollTop property by the specified
            // step.
            $this.find("ul").animate({
                scrollTop: "-=" + step + "px"
            });
        }).bind("mouseover", function (event) {
            scrolling = true;
            scrollContent("up");
        }).bind("mouseout", function (event) {
            scrolling = false;
        });


        $this.find(".scrollDown").bind("click", function (event) {
            event.preventDefault();
            $this.find("ul").animate({
                scrollTop: "+=" + step + "px"
            });
        }).bind("mouseover", function (event) {
            scrolling = true;
            scrollContent("down");
        }).bind("mouseout", function (event) {
            scrolling = false;
        });

        function scrollContent(direction) {
            var amount = (direction === "up" ? "-=3px" : "+=3px");
            $this.find("ul").animate({
                scrollTop: amount
            }, 1, function () {
                if (scrolling) {
                    scrollContent(direction);
                }
            });
        }
    });

        ';
    }

    /**
     * Shortcode type
     * @return string
     */
    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_SELF_CLOSING;
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        $atts = $this->getAttributesWithQuery(array(
            'title' => array('label' => __('Title', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'height' => array('label' => __('Recent posts box height','ct_theme'),'default' => '220','type'=> 'input'),
            'widgetmode' => array('default' => 'false', 'type' => false),
            'limit' => array('label' => __('limit', 'ct_theme'), 'default' => 3, 'type' => 'input'),
            'type' => array('label' => __('widget type', 'ct_theme'), 'default' => 'simple', 'type' => "select", 'choices' => array('simple' => __('simple', 'ct_theme'), 'image' => __('image', 'ct_theme'))),
            'widget_show_excerpt' => array('label' => __('widget show excerpt', 'ct_theme'), 'default' => 'hide', 'type' => "select", 'choices' => array('show' => __('show', 'ct_theme'), 'hide' => __('hide', 'ct_theme')), 'help' => __("Optional summary or description of a post in sidebar or footer. (use the " . htmlspecialchars("<!--widget_more-->") . " tag in the post content)", 'ct_theme')),
            'class' => array('label' => __("Custom class", 'ct_theme'), 'default' => '', 'type' => 'input'),


        ));
        return $atts;
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-quote-left' ) );
    }
}

new ctRecentPostsShortcode();