<?php

/**
 * BlockQuote shortcode
 */
class ctBlockQuoteShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Block quote';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'blockquote';
    }

    /**
     * Returns shortcode type
     * @return mixed|string
     */

    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_ENCLOSING;
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $mainContainerAtts = array(
            'class' => array(),
            'id'=>$id
        );
        $contentShortcode = '[paragraph]' . $content . '[/paragraph]';
        $authorHtml = '<footer>' . $footer . '</footer>';


        $html = '<blockquote ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . '>';
        $html .= $contentShortcode . $authorHtml;
        $html .= '</blockquote>';

        return do_shortcode($html);
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'content' => array('label' => __('content', 'ct_theme'), 'default' => '', 'type' => "textarea"),
            'footer' => array('label' => __('footer', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'id' => array('default' => false, 'type' => false),
            'class' => array('label' => __('Custom class', 'ct_theme'), 'default' => '', 'type' => 'input',)
        );
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-quote-left' ) );
    }
}

new ctBlockQuoteShortcode();