<?php

/**
 * Testimonial shortcode
 */
class ctFeaturedTestimonialShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface
{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Featured Testimonial';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'featured_testimonial';
    }

    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $mainContainerAtts = array(
            'class' => array(
                'clearfix'

            )
        );


        $testObject = get_post($testimonial);
        $custom = get_post_custom($testObject->ID);
        $author = isset($custom["testimonial_author"][0]) ? $custom["testimonial_author"][0] : "";
        $image = ct_get_feature_image_src($testimonial, 'full');

        $post_content = $testObject->post_content;
        $testIndexPage = get_permalink(ct_get_option('testimonials_index_page', ''));

        if (!empty($testIndexPage)) {
            $author = '<a href="' . esc_url($testIndexPage) . '#' . $testObject->ID . '"><h3>' . $author . '</h3></a>';
            if (!empty($image)) {
                $img = '<a href="' . esc_url($testIndexPage) . '#' . $testObject->ID . '"><img src="' . esc_url($image) . '" class="pull-left" alt="' . __('testimonial image', 'ct_theme') . '"></h3></a>';

            } else {
                $img = '';
            }

        } else {
            if (!empty($image)) {
                $img = '<img src="' . esc_url($image) . '" class="pull-left" alt="' . __('testimonial image', 'ct_theme') . '">';
            } else {
                $img = '';
            }
        }


        $html = $img . '
                <h3>' . $author . '</h3>
                <hr>

                    &bdquo;' . $post_content . '&rdquo;

                <hr>
                <div class="pull-left article-socials">
                ' . ctGetTwitterShareBtn($twitter_share_message, '', '', $twitter_button_label, 'fa fa-twitter') .
            ctGetFbShareBtn(__('share', 'ct_theme'), __('Share', 'ct_theme')) .
            '
              </div>
              <div class="pull-left ">
              ' . ctAddthisButton() . '
               </div>
                <div class="clearfix"></div>
            ';

        return do_shortcode($html);

    }


    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        $attributes['limit'] = 1000;
        $recentposts = get_posts(array('post_type' => 'testimonial'), $attributes);
        $testimonials = array();
        $counter = 0;
        foreach ($recentposts as $p) {
            $counter++;
            $testimonials[$p->ID] = $p->post_title;

        }

        return array(

            'testimonial' => array('label' => __('Select program', 'ct_theme'), 'default' => '', 'type' => 'select', 'choices' =>
                $testimonials, 'help' => __("You can display link to program", 'ct_theme')),
            'twitter_button_label' => array('label' => __('twitter button label', 'ct_theme'), 'default' => __('tweet', 'ct_theme'), 'type' => 'input'),
            'twitter_share_message' => array('label' => __('twitter share message', 'ct_theme'), 'default' => __('', 'ct_theme'), 'type' => 'input'),
            'facebook_button_label' => array('label' => __('facebook button label', 'ct_theme'), 'default' => __('share', 'ct_theme'), 'type' => 'input'),
        );
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo()
    {
        return new ctVisualComposerInfo($this, array('icon' => 'fa-quote-left'));
    }
}

new ctFeaturedTestimonialShortcode();