<?php

/**
 * Draws team
 */
class ctTestimonialsShortcode extends ctShortcodeQueryable implements ctVisualComposerShortcodeInterface
{

    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Testimonials';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'testimonials';
    }


    /**
     * Handles shortcode
     *
     * @param $atts
     * @param null $content
     *
     * @return string
     */

    public function handle($atts, $content = null)
    {

        $attributes = shortcode_atts($this->extractShortcodeAttributes($atts), $atts);
        extract($attributes);

        $posts = $this->getCollection($attributes, array('post_type' => 'testimonial'));
        $customPostSocials = new ctSocialsMetaFields();

        $testimonialsHtml = '';
        $counter=0;

        foreach ($posts as $p) {
//            /$id = 'testimonial'.++$counter;
            $id = $p->ID;

            $custom = get_post_custom($p->ID);

            $author = isset($custom["testimonial_author"][0]) ? $custom["testimonial_author"][0] : "";
            $content = $p->post_content;

            if (ct_get_option('testomonials_index_show_tweet', 1)) {
                $twitterHtml = ctGetTwitterShareBtn(ct_get_option('testomonials_twitter_message', ''), ct_get_option('testomonials_twitter_link', '') == 'yes' ? get_permalink($p->ID) : '', 'Tooltip on top', 'tweet', 'fa fa-twitter');
            } else {
                $twitterHtml = '';
            }

            if (ct_get_option('testomonials_index_show_fb_share', 1)) {
                $shareHtml = ctGetFbShareBtn('share', 'Tooltip on top', 'top', 'fa fa-facebook', 'btn btn-primary uppercase', '_blank', 'tooltip', '#'.$id);
            } else {
                $shareHtml = '';
            }

            if (ct_get_option('testomonials_index_show_socials', 1)) {
                $socialsHtml = $customPostSocials->getTheSocialsHtml(array('align' => 'pull-right', 'style'=>'small'), $p->ID);

            } else {
                $socialsHtml = '';
            }

            if (!empty($twitterHtml) || !empty($shareHtml) || !empty($socialsHtml)) {
                $socialsArea = '<div class="socials-top"><div class="pull-left">' . $twitterHtml . $shareHtml .  '</div>'.$socialsHtml.'</div><div class="clearfix"></div>';
            } else {
                $socialsArea = '';
            }

            //forward params
            $testimonialsHtml .= ('[blockquote id="'.$id.'" footer="' . $author . '" ]' . $content . '[/blockquote]');
            $testimonialsHtml .= $socialsArea . '<hr>';


        }

        return do_shortcode($testimonialsHtml);
    }


    /**
     * Returns params from array ($custom)
     *
     * @param $arr
     * @param $key
     * @param int $index
     * @param string $default
     *
     * @return bool
     */

    protected function getFromArray($arr, $key, $index = 0, $default = '')
    {
        return isset($arr[$key][$index]) ? $arr[$key][$index] : $default;
    }

    /**
     * Shortcode type
     * @return string
     */
    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_SELF_CLOSING;
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        $atts = $this->getAttributesWithQuery(array(
            'limit' => array(
                'label' => __('limit', 'ct_theme'),
                'default' => 20,
                'type' => 'input',
                'help' => __("Number of elements", 'ct_theme')
            ),
        ));

        if (isset($atts['cat'])) {
            unset($atts['cat']);
        }

        return $atts;
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo()
    {
        return new ctVisualComposerInfo($this, array('icon' => 'fa-user'));
    }


}


new ctTestimonialsShortcode();
