<?php

/**
 * ctChapter shortcode
 */
class ctSectionShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface
{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Section';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'section';
    }

    /**
     * Returns shortcode type
     * @return mixed|string
     */

    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_ENCLOSING;
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $class='';
        $mainContainerAtts = array(
            'class' => array(
                'shadow-box',
                'padding-normal',
                $onepager == 'yes' ? 'section' : '',
                $class
            ),
            'id' => $id
        );


       
        $html = '<div ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . ' >';
        $html .= '<h4 class="color-motive-light uppercase">' . $title . '</h4>';
        $html .= $content;
        $html .= '</div>';
        return do_shortcode($html);
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {

        return array(
            'id' => array('label' => __('ID', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'title' => array('label' => __('Title', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'content' => array('label' => __('content', 'ct_theme'), 'default' => '', 'type' => "textarea"),
            'onepager' => array('label' => __('Onepager Section?', 'ct_theme'), 'default' => 'no', 'type' => 'select',
                'choices' => array('yes' => 'yes', 'no' => 'no'), 'help' => __("Onepager nav destination element ?", 'ct_theme')),

        );
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo()
    {
        return new ctVisualComposerInfo($this, array('icon' => 'fa-cogs'));
    }
}

new ctSectionShortcode();