<?php

/**
 * Flex Slider Item shortcode
 */
class ctTopSliderItemShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface{


    public static $next_section;

    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Top Slider Item';
    }

    /**
     * Parent shortcode name
     * @return null
     */
    public function getParentShortcodeName()
    {
        return 'top_slider';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'top_slider_item';
    }

    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */
    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $img1_left = is_numeric((str_replace('px', '', $img1_left))) ? 'data-left="' . esc_attr($img1_left . 'px').'"' : '';
        $img2_left = is_numeric((str_replace('px', '', $img2_left))) ? 'data-left="' . esc_attr($img2_left . 'px').'"' : '';
        $link_left = is_numeric((str_replace('px', '', $link_left))) ? 'data-left="' . esc_attr($link_left . 'px').'"' : '';


        $img1_right = is_numeric((str_replace('px', '', $img1_right))) ? 'data-right="' . esc_attr($img1_right . 'px').'"' : '';
        $img2_right = is_numeric((str_replace('px', '', $img2_right))) ? 'data-right="' . esc_attr($img2_right . 'px').'"' : '';
        $link_right = is_numeric((str_replace('px', '', $link_right))) ? 'data-right="' . esc_attr($link_right . 'px').'"' : '';

        $img1_bottom = is_numeric((str_replace('px', '', $img1_bottom))) ? 'data-bottom="' . esc_attr($img1_bottom . 'px').'"' : '';
        $img2_bottom = is_numeric((str_replace('px', '', $img2_bottom))) ? 'data-bottom="' . esc_attr($img2_bottom . 'px').'"' : '';
        $link_bottom = is_numeric((str_replace('px', '', $link_bottom))) ? 'data-bottom="' . esc_attr($link_bottom . 'px').'"' : '';

        $img1_top = is_numeric((str_replace('px', '', $img1_top))) ? 'data-top="' . esc_attr($img1_top . 'px').'"' : '';
        $img2_top = is_numeric((str_replace('px', '', $img2_top))) ? 'data-top="' . esc_attr($img2_top . 'px').'"' : '';
        $link_top = is_numeric((str_replace('px', '', $link_top))) ? 'data-top="' . esc_attr($link_top . 'px').'"' : '';

        $link_icon = ($link_icon != '') ? ' <i class="fa ' . $link_icon . '"></i>' : '';


        $item = '<li>';
        $item .= '<div class="inner">';
        $item .= '
                        <div class="object animated absolute" ' . $img1_left . ' ' . $img1_bottom . ' ' . $img1_right . ' ' . $img1_top . ' data-fx="' . htmlspecialchars($img1_anim) . '">
                        <img src="' . $imgsrc1 . '" alt="'.__('slider image','ct_theme').'">
                        </div>
        ';
        $item .= '
                        <div class="object animated absolute" ' . $img2_left . ' ' . $img2_bottom . ' ' . $img2_right . ' ' . $img2_top . ' data-fx="' . htmlspecialchars($img2_anim) . '">
                        <img src="' . $imgsrc2 . '" alt="'.__('slider image','ct_theme').'">
                        </div>
        ';
        $item .= '
                         <div class="object animated absolute" ' . $link_left . ' ' . $link_bottom . ' ' . $link_right . ' ' . $link_top . ' data-fx="' . htmlspecialchars($link_anim) . '">
                        <a href="' . esc_url($link_url) . '">' . $link_text . $link_icon . '</a></div>';

        $item .= '</div></li>';
        return do_shortcode($item);
    }


    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {

        if (class_exists('ctCssAnimatePlugin')) {
            $anim = new ctCssAnimatePlugin();
            $anim_choices = $anim->addCustomNormalizedAttributes(null);
            $anim_choices = $anim_choices['animation']['choices'];
        } else {
            $anim_choices = array();
        }

        return array(
            'imgsrc1' => array('label' => __("Image 1", 'ct_theme'), 'default' => '', 'type' => 'image', 'help' => __("Image", 'ct_theme')),
            'imgsrc2' => array('label' => __("Image 2", 'ct_theme'), 'default' => '', 'type' => 'image', 'help' => __("Image", 'ct_theme')),
            'link_text' => array('label' => __('Link text', 'ct_theme'), 'default' => '', 'type' => "input"),
            'link_url' => array('label' => __('Link URL', 'ct_theme'), 'default' => '', 'type' => "input"),
            'link_icon' => array('label' => __('Link Awesome Icon', 'ct_theme'), 'default' => 'fa-chevron-right', 'type' => "input"),


            'img1_anim' => array('label' => __('Header animation effect', 'ct_theme'), 'default' => 'bounceInLeft', 'type' => 'select', 'choices' => $anim_choices),
            'img2_anim' => array('label' => __('Sub header animation effect', 'ct_theme'), 'default' => 'bounceInDown', 'type' => 'select', 'choices' => $anim_choices),
            'link_anim' => array('label' => __('Button animation effect', 'ct_theme'), 'default' => 'flipInY', 'type' => 'select', 'choices' => $anim_choices),

            'img1_left' => array('label' => __('Image 1 Left', 'ct_theme'), 'default' => '', 'type' => "input"),
            'img1_right' => array('label' => __('Image 1 Right', 'ct_theme'), 'default' => '', 'type' => "input"),
            'img1_bottom' => array('label' => __('Image 1 Bottom', 'ct_theme'), 'default' => '', 'type' => "input"),
            'img1_top' => array('label' => __('Image 1 Top', 'ct_theme'), 'default' => '', 'type' => "input"),

            'img2_left' => array('label' => __('Image 2 Left', 'ct_theme'), 'default' => '', 'type' => "input"),
            'img2_right' => array('label' => __('Image 2 Right', 'ct_theme'), 'default' => '', 'type' => "input"),
            'img2_bottom' => array('label' => __('Image 2 Bottom', 'ct_theme'), 'default' => '', 'type' => "input"),
            'img2_top' => array('label' => __('Image 2 Top', 'ct_theme'), 'default' => '', 'type' => "input"),

            'link_left' => array('label' => __('Link Left', 'ct_theme'), 'default' => '', 'type' => "input"),
            'link_right' => array('label' => __('Link Right', 'ct_theme'), 'default' => '', 'type' => "input"),
            'link_bottom' => array('label' => __('Link Bottom', 'ct_theme'), 'default' => '', 'type' => "input"),
            'link_top' => array('label' => __('Link 1 Top', 'ct_theme'), 'default' => '', 'type' => "input"),
        );
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-picture-o', 'container'=>true ) );
    }
}

new ctTopSliderItemShortcode();