<?php

/**
 * Flex Slider shortcode
 */
class ctTopSliderShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Top Slider';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'top_slider';
    }

    public function enqueueScripts()
    {
        wp_register_script('ct-flex-slider', CT_THEME_ASSETS . '/js/jquery.flexslider-min.js', array('jquery'), false, true);
        wp_enqueue_script('ct-flex-slider');

        wp_register_script('ct-flexslider_init', CT_THEME_ASSETS . '/js/ctFlexsliderInit.js', array('ct-flex-slider'), false, true);
        wp_enqueue_script('ct-flexslider_init');

    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        $attributes = shortcode_atts($this->extractShortcodeAttributes($atts), $atts);
        extract($attributes);

        //ctParallaxSliderItemShortcode::$next_section = $next_section;

        $id = ($id == '') ? 'top_slider' . rand(100, 1000) : $id;
        //$this->addInlineJS($this->flexSliderGetInlineJS($attributes, $id),true);

        $mainContainerAtts = array(
            'class' => array(
                'flexslider',
                'std-slider',
                is_page_template('page-onepager.php')?'border-none':''
            ),
            'data-height' => $height,
            'data-loop' => $loop,
            'data-smooth' => $smooth,
            'data-slideshow' => $slideshow,
            'data-speed' => $speed,
            'data-animspeed' => $animspeed,
            'data-controls' => $controls,
            'data-dircontrols' => $dircontrols,
            'id' => $id

        );

        $html = '<section' . $this->buildContainerAttributes($mainContainerAtts, $atts) . ' >';
        $html .= '<div class="container">';
        $html .= '<ul class="slides">' . $content . '</ul></div>';
        $html .= '</section>';

        return do_shortcode($html);
    }

    /**
     * returns JS
     * @param $id
     * @return string
     */
    protected function flexSliderGetInlineJS($attributes, $id)
    {
        extract($attributes);

        return '
';

    }

    /**
     * Returns config
     * @return null
     *
     *
     */
    public function getAttributes()
    {
        return array(
            'id' => array('label' => __('Slider id', 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __("html id attribute", 'ct_theme')),
            'height' => array('label' => __('Height', 'ct_theme'), 'default' => '560', 'type' => 'input'),
            'loop' => array('label' => __('Loop', 'ct_theme'), 'default' => 'true', 'type' => 'select', 'choices' => array("true" => __("true", "ct_theme"), "false" => __("false", "ct_theme"))),
            'smooth' => array('label' => __('Smooth', 'ct_theme'), 'default' => 'false', 'type' => 'select', 'choices' => array("true" => __("true", "ct_theme"), "false" => __("false", "ct_theme"))),
            'slideshow' => array('label' => __('Slideshow', 'ct_theme'), 'default' => 'true', 'type' => 'select', 'choices' => array("true" => __("true", "ct_theme"), "false" => __("false", "ct_theme"))),
            'speed' => array('label' => __('Speed', 'ct_theme'), 'default' => 15000, 'type' => 'input', 'help' => __('slide transition speed in miliseconds (1 sec = 1000 milisec)', 'ct_theme')),
            'animspeed' => array('label' => __('Animation speed', 'ct_theme'), 'default' => 550, 'type' => 'input', 'help' => __('slide transition speed in miliseconds (1 sec = 1000 milisec)', 'ct_theme')),
            'class' => array('label' => __('Custom class', 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('Adding custom class allows you to set diverse styles in css to the element. Type in name of class, which you defined in css. You can add as much classes as you like.', 'ct_theme')),
            'controls' => array('label' => __('Control navigation', 'ct_theme'), 'default' => 'false', 'type' => 'select', 'choices' => array("true" => __("true", "ct_theme"), "false" => __("false", "ct_theme"))),
            'dircontrols' => array('label' => __('Direction navigation', 'ct_theme'), 'default' => 'true', 'type' => 'select', 'choices' => array("true" => __("true", "ct_theme"), "false" => __("false", "ct_theme"))),


        );
    }

    public function getChildShortcodeInfo()
    {
        return array('name' => 'top_slider_item', 'min' => 1, 'max' => 20, 'default_qty' => 3);
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-picture-o' ) );
    }

}

new ctTopSliderShortcode();

//#28147
if(class_exists('WPBakeryShortCodesContainer')){
    class WPBakeryShortcode_top_slider extends WPBakeryShortCodesContainer{}
}