<?php
/**
 * Title row shortcode
 */
class ctTitleRowShortcode extends ctShortcode {

	/**
	 * Returns name
	 * @return string|void
	 */
	public function getName() {
		return 'Title row';
	}

	/**
	 * Shortcode name
	 * @return string
	 */
	public function getShortcodeName() {
		return 'title_row';
	}

	/**
	 * Handles shortcode
	 * @param $atts
	 * @param null $content
	 * @return string
	 */

	public function handle($atts, $content = null) {
		extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));
        $ctBreadcrumb = new ctBreadcrumbs();

		$level = ct_get_option('pages_header_level','1');
		$transform = ct_get_option('pages_header_transform','uppercase');
		$hColor = ct_get_option('pages_header_color','#00a3d9');
		$hWeight = ct_get_option('pages_header_weight','ct-fw-400');

		$breadcrumbsHtml = '';

		if($breadcrumbs == 'yes' || $breadcrumbs == 'true'){
                $breadcrumbsHtml = apply_filters('ct.breadcrumbs.display','',
                    array('wrapper_class'=>"breadcrumb")
                );
		}



		$id = $id ? (' id="' . $id . '"') : '';
		$html = ($header || $breadcrumbs=='yes') ? '<h'.$level.' class="color-motive '.$transform.$hWeight.'" style="color:'.$hColor.'">'.$header.'</h'.$level.'>'.($line=='yes'||$line=='true'?'<hr>'.$breadcrumbsHtml:'') : '';



		//return do_shortcode('[full_width]'.$html.'[/full_width]');
        return do_shortcode($html);
	}

	/**
	 * is template with sidebar?
	 * @return bool
	 */
	protected function isSidebar() {
		return is_page_template('page-custom.php') || is_page_template('page-custom-left.php');
	}

	/**
	 * Returns config
	 * @return null
	 */
	public function getAttributes() {
		return array(
			'id' => array('label' => __('header id', 'ct_theme'), 'default' => 'BlogHeader', 'type' => 'input', 'help' => __("html id attribute", 'ct_theme')),
			'header' => array('label' => __('header', 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __("Header text", 'ct_theme')),
            'breadcrumbs' => array('label' => __('breadcrumbs', 'ct_theme'), 'default' => 'no', 'type' => 'select', 'choices' => array('yes' => __('yes', 'ct_theme'), 'no' => __('no', 'ct_theme')), 'help' => __("Show breadcrumbs path?", 'ct_theme')),
            'line' => array('label' => __('line afret header?', 'ct_theme'), 'default' => 'no', 'type' => 'select', 'choices' => array('yes' => __('yes', 'ct_theme'), 'no' => __('no', 'ct_theme')), 'help' => __("Show line after header?", 'ct_theme')),

        );
	}
}

new ctTitleRowShortcode();