<?php
/**
 * Tab shortcode
 */
class  ctBigTabShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface{

	/**
	 * Tabs counter
	 * @var int
	 */

	protected static $counter = 0;

	/**
	 * @inheritdoc
	 */
	public function __construct() {
		parent::__construct();

		//connect for additional code
		//remember - method must be PUBLIC!
		$this->connectPreFilter('big_tabs', array($this, 'handlePreFilter'));
	}


	/**
	 * Returns name
	 * @return string|void
	 */
	public function getName() {
		return 'Big Tab';
	}

	/**
	 * Shortcode name
	 * @return string
	 */
	public function getShortcodeName() {
		return 'big_tab';
	}

	/**
	 * Handles shortcode
	 * @param $atts
	 * @param null $content
	 * @return string
	 */
	public function handle($atts, $content = null) {
		extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));
		$counter = ++self::$counter;

        //$header = $title?'<h4 class="uppercase title">'.$title.'</h4>':'';



        $this->setData($counter,'<div class="tab-pane shadow-box" id="tab-'.self::$counter.'">'.do_shortcode($content).'<div class="clearfix"></div></div>');

		return '
			<li><a href="#tab-'.$counter.'" data-toggle="tab">
                <span class="title uppercase">'.$title.'</span><img src="'.esc_url($imgsrc).'" alt="'.__('tab image','ct_theme').'">
            </a></li>';
	    }


	/**
	 * Adds content before filters
	 * @param string $content
	 * @return string
	 */
	public function handlePreFilter($content) {
		//here - add all available content
        $tabContainers = '<div class="tab-content">';
		foreach ($this->getAllData() as $data) {
            $tabContainers.=$data;
		}
        $tabContainers.= '<div class="clearfix"></div> </div>';
		return $tabContainers;
	}

	/**
	 * Parent shortcode name
	 * @return null
	 */

	public function getParentShortcodeName() {
		return 'big_tabs';
	}


	/**
	 * Returns config
	 * @return null
	 */
	public function getAttributes() {
		return array(
            'widgetmode' => array('default' => 'false', 'type' => false),
			'title' => array('label' => __('header', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'imgsrc' => array('label' => __("source", 'ct_theme'), 'default' => '', 'type' => 'image', 'help' => __("Image", 'ct_theme')),
            'content' => array('label' => __('content', 'ct_theme'), 'default' => '', 'type' => 'textarea'),
			);
	}

	/**
	 * Returns additional info about VC
	 * @return ctVisualComposerInfo
	 */
	public function getVisualComposerInfo() {
		return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-list-alt' , 'container'=>true) );
	}

}

new ctBigTabShortcode();