<?php

/**
 * Big Tabs shortcode
 */
class ctBigTabsShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Big Tabs';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'big_tabs';
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        $attributes = shortcode_atts($this->extractShortcodeAttributes($atts), $atts);
        extract($attributes);
        $this->addInlineJS($this->getInlineJS(), true);


        $mainContainerAtts = array(
            'class' => array(
                'sub-menu',
            )
        );
        //parse shortcode before filters
        $itemsHtml = do_shortcode($content);
        $tabs = '<section ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . '>';
        $tabs .= '<ul class="nav nav-tabs">';
        $tabs .= $itemsHtml;
        $tabs .= '</ul>';
        $tabs .= $this->callPreFilter($content); //reference
        $tabs .= '</section>';
        //clean current tab cache
        $this->cleanData('big_tab');

        return do_shortcode($tabs);
    }

    /**
     * returns inline js
     * @param $attributes
     * @param $id
     * @return string
     */
    protected function getInlineJS()
    {
        return '
            /* ==== OPEN / CLOSE TAB ON MOUSECLICK ==== */

var $tab_link = jQuery(".sub-menu .nav-tabs > li > a");

jQuery(".sub-menu [data-toggle=tab]").click(function(){
    var $parent = jQuery(this).parent();
    if ($parent.hasClass("active")){
        $tab_link.removeClass("transparent");
        if(!jQuery(jQuery(this).attr("href")).hasClass("active")){
            $tab_link.not(this).addClass("transparent");
        }
        jQuery(jQuery(this).attr("href")).toggleClass("active");
    } else{
        $tab_link.removeClass("transparent");
        $tab_link.not(this).addClass("transparent");
    }
})
jQuery(document).on("click", function(event) {
    if (!jQuery(event.target).closest(".sub-menu").length ) {
        $tab_link.removeClass("transparent");
        $tab_link.parent().removeClass("active");
        jQuery(".sub-menu .tab-pane").removeClass("active");
    }
});


        ';
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'widgetmode' => array('default' => 'false', 'type' => false),
            'class' => array('label' => __('Custom class', 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __('Adding custom class allows you to set diverse styles in css to the element. Type in name of class, which you defined in css. You can add as much classes as you like.', 'ct_theme')),
        );

    }

    /**
     * Child shortcode info
     * @return array
     */

    public function getChildShortcodeInfo()
    {
        return array('name' => 'big_tab', 'min' => 1, 'max' => 4, 'default_qty' => 4);
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-list-alt' ) );
    }

}

new ctBigTabsShortcode();




