<?php

/**
 * Pricelist shortcode
 */
class ctPersonBoxShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Person box';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'person_box';
    }

    /**
     * Returns shortcode type
     * @return mixed|string
     */

    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_ENCLOSING;
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));
        //$this->addInlineJS($this->getInlineJS(), true);


        $arr = $atts;

        $mainContainerAtts = array(
            'class' => array(
                'person-box',
                $class
            )
        );


        $html = '

                            <img src="' . $image . '" alt="'.__('team member','ct_theme').'">
                            <div class="description">
                                <span class="name">' . $title . '</span>
                                <div class="inner-box">
                                    <span class="function">' . $sub_title . '</span>
                                    <p class="person-text">' . $content . '</p>
                                </div>
                                <div class="contacts">
                                    <span class="person-contacts-title">
                                        ' . $person_contacts_title . '
                                    </span>
                                    <div class="inner-box">
                                        <div class="icon">
                                            <i class="fa fa-phone"></i>
                                        </div>
                                        <div class="contact">
                                            ' . $phone . '
                                        </div>
                                    </div>
                                    <div class="clearfix"></div>
                                    <div class="inner-box">
                                        <div class="icon">
                                            @
                                        </div>
                                        <div class="contact">
                                            <a href="mailto:' . is_email($email) . '">' . $email . '</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
        ';


        $html = '<div ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . '>' . do_shortcode($html) . '</div>';


        return do_shortcode($html);
    }

    /**
     * returns inline js
     * @param $attributes
     * @param $id
     * @return string
     */
    protected function getInlineJS()
    {
        return '

            /* ========================================================= */
    /* ==== CLICK EVENTS FOR SMALL DEVICES INSTEAD OF HOVER ==== */

    if(device.mobile() || device.tablet()){
        jQuery(".person-box .description").click(function (){
            jQuery(this).toggleClass("hover");
        })
    }

        ';
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'title' => array('label' => __('Title', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'sub_title' => array('label' => __('Sub title', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'person_contacts_title' => array('label' => __('Person contacts title', 'ct_theme'), 'default' => '', 'type' => 'input'),

            'phone' => array('label' => __('Phone', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'email' => array('label' => __('E-mail', 'ct_theme'), 'default' => '', 'type' => 'input'),
            'image' => array('label' => __("Image", 'ct_theme'), 'default' => '', 'type' => 'image', 'help' => __("Image source", 'ct_theme')),
            'content' => array('label' => __('content', 'ct_theme'), 'default' => '', 'type' => 'textarea'),
            'class' => array('label' => __("Custom class", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __("Custom class name", 'ct_theme')),
        );
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-user' ) );
    }

}

new ctPersonBoxShortcode();
