<?php

/**
 * Draws team
 */
class ctTeamShortcode extends ctShortcodeQueryable implements ctVisualComposerShortcodeInterface
{

    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Team';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'team';
    }


    /**
     * Handles shortcode
     *
     * @param $atts
     * @param null $content
     *
     * @return string
     */

    public function handle($atts, $content = null)
    {

        $attributes = shortcode_atts($this->extractShortcodeAttributes($atts), $atts);
        extract($attributes);

        $team = $this->getCollection($attributes, array('post_type' => 'team'));

        $counter = 0;
        $counter2 = 0;

        $teamBoxHtml = '';

        foreach ($team as $p) {
            $custom = get_post_custom($p->ID);


            $job_position = isset($custom["job_position"][0]) ? $custom["job_position"][0] : "";
            $phone = isset($custom["phone"][0]) ? $custom["phone"][0] : "";
            $email = isset($custom["email"][0]) ? $custom["email"][0] : "";
            $content = $p->post_content;

            if (has_post_thumbnail($p->ID)) {
                $image = ct_get_feature_image_src($p->ID, 'full');
            } else {
                $image = '';
            }

            $counter++;
            $counter2++;
            if ($counter2 == 1) {
                $teamBoxHtml .= '[row top_space="true"]';
            }

            if ($person_contacts_title != '') {
                $contacts_title = strtr($person_contacts_title, array('%name%' => get_the_title($p->ID)));
            } else {
                $contacts_title = '';
            }

            if ($columns == 2) {
                $teamBoxHtml .= '<div class="col-md-6 col-sm-12">';
            } elseif ($columns == 3) {
                $teamBoxHtml .= '<div class="col-md-4 col-sm-6">';
            } else {
                $teamBoxHtml .= '<div class="col-md-3 col-sm-4">';
            }


            //forward params
            $teamBoxHtml .= ('[person_box person_contacts_title="' . $contacts_title . '" phone="' . $phone . '" email="' . $email . '" title="' . get_the_title($p->ID) . '" sub_title="' . $job_position . '" image="' . $image . '" ]' . $content . '[/person_box]');
            $teamBoxHtml .= '</div>';

            if ($counter2 == $columns || $counter == count($team)) {
                $counter2 = 0;
                $teamBoxHtml .= '[/row]';
            }
        }

        return do_shortcode($teamBoxHtml);
    }


    /**
     * Returns params from array ($custom)
     *
     * @param $arr
     * @param $key
     * @param int $index
     * @param string $default
     *
     * @return bool
     */

    protected function getFromArray($arr, $key, $index = 0, $default = '')
    {
        return isset($arr[$key][$index]) ? $arr[$key][$index] : $default;
    }

    /**
     * Shortcode type
     * @return string
     */
    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_SELF_CLOSING;
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        $atts = $this->getAttributesWithQuery(array(
            'limit' => array(
                'label' => __('limit', 'ct_theme'),
                'default' => 20,
                'type' => 'input',
                'help' => __("Number of elements", 'ct_theme')
            ),
            'person_contacts_title' => array(
                'label' => __('Person contacts title', 'ct_theme'),
                'default' => __('Contact %name%', 'ct_theme'),
                'type' => 'input',
                'help' => __("Available data: %title% (team member name)", 'ct_theme')
            ),

            'columns' => array('label' => __('Columns', 'ct_theme'), 'default' => '3', 'type' => 'select',
                'choices' => array('2' => '2', '3' => '3', '4' => '4'), 'help' => __("Columns number", 'ct_theme')),

        ));

        if (isset($atts['cat'])) {
            unset($atts['cat']);
        }

        return $atts;
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo()
    {
        return new ctVisualComposerInfo($this, array('icon' => 'fa-user'));
    }


}


new ctTeamShortcode();
