<?php

/**
 * Header shortcode
 */
class ctBlockHeaderShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Block Header';
    }


    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'block_header';
    }

    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        $pClass = '';
        $style = '';
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $styleName = '';
        if ($style !== '') {
            if ($style == 'small') {
                $styleName = 'page-header';
            } else {
                $styleName = 'hdr' . $style;
            }
        }

	    $pClass = 'class="headerDesc"';
        if ($align == 'left'){
            $align='text-left';
        }elseif ($align =='right'){
            $align='text-left';
        }else{
            $align='text-center';
            $pClass='class="larger headerDesc"';
        }

        $mainContainerAtts = array(
            'class' => array(
                'page-header',
                $align,
                $class
            ),
        );

        $h1Html = '<h1 class="page-title">'.$header.'</h1>';
        $h2Html = '<h2>'.$subheader.'</h2>';

        $html = ' <header ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . '>';
        $html .= $h1Html;
        $html .= $h2Html;
        $html .= '<div '.$pClass.'>'.$content.'</div>';
        $html .= '</header>';

        return do_shortcode($html);
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'header' => array('label' => __("Header", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __("Header", 'ct_theme')),
            'subheader' => array('label' => __("Sub header", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __("Sub header", 'ct_theme')),
            'content' => array('label' => __('Content', 'ct_theme'), 'default' => '', 'type' => "textarea"),
            'align' => array('label' => __('align', 'ct_theme'), 'default' => 'left', 'type' => 'select', 'options' => array('left' => __('Left', 'ct_theme'), 'center' => __('Center', 'ct_theme'), 'right' => __('Right', 'ct_theme')), 'help' => __("Header align", 'ct_theme')),
            'class' => array('label' => __("Header custom class", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __("custom class, adding custom class allows you to set diverse styles in css to the element. type in name of class, which you defined in css. you can add as much classes as you like.", 'ct_theme')),
        );
    }
    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-header' ) );
    }

}

new ctBlockHeaderShortcode();