<?php

/**
 * Header shortcode
 */
class ctHeader extends ctShortcode implements ctVisualComposerShortcodeInterface{



    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Header';
    }


    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'header';
    }

    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        $style = '';
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $styleName = '';
        if ($style !== '') {
            if ($style == 'small') {
                $styleName = 'page-title';
            }
        }

        $class = $class ? $class : '';
        if ($motive == 'yes' || $motive == 'true') {
            $class .= ' color-motive';
        }
        if ($title_header == 'yes' || $title_header == 'true') {
            $class .= ' uppercase title';
        }
        $html = '<h' . $level . ' class="' . $class . '">' . do_shortcode($content) . '</h' . $level . '>';


        return do_shortcode($html);
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'level' => array('label' => __('Level of header', 'ct_theme'), 'default' => '4', 'type' => 'select', 'options' => array(
                '1' => '1',
                '2' => '2',
                '3' => '3',
                '4' => '4',
                '5' => '5',
                '6' => '6',
            )),

            'motive' => array('label' => __('Motive color ?', 'ct_theme'), 'default' => 'no', 'type' => 'select', 'choices' => array('yes' => __('yes', 'ct_theme'), 'no' => __('no', 'ct_theme')),),
            'title_header' => array('label' => __('Title header ?', 'ct_theme'), 'default' => 'no', 'type' => 'select', 'choices' => array('yes' => __('yes', 'ct_theme'), 'no' => __('no', 'ct_theme')),),
            'content' => array('label' => __('Header text', 'ct_theme'), 'default' => '', 'type' => "textarea"),
            'class' => array('label' => __("Header custom class", 'ct_theme'), 'default' => '', 'type' => 'input', 'help' => __("custom class, adding custom class allows you to set diverse styles in css to the element. type in name of class, which you defined in css. you can add as much classes as you like.", 'ct_theme')),
        );
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-header' ) );
    }

}

new ctHeader();