<?php

/**
 * Paragraph shortcode
 */
class ctParagraphShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Paragraph';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'paragraph';
    }

    /**
     * Returns shortcode type
     * @return mixed|string
     */

    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_ENCLOSING;
    }

    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));

        $mainContainerAtts = array(
            'class' => array(
                ($larger == 'yes' || $larger == 'true') ? 'h4 color-motive' : '',
                $class
            ),
        );

        if ($larger == 'yes' || $larger == 'true') {
            return do_shortcode('<span ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . '>' . $content . '</span>');

        } else {
            return do_shortcode('<p ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . '>' . $content . '</p>');

        }
    }


    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'larger' => array('label' => __('Larger', 'ct_theme'), 'default' => 'no', 'type' => 'select', 'options' => array('yes' => 'yes', 'no' => 'no')),
            'content' => array('label' => __('Content', 'ct_theme'), 'default' => '', 'type' => "textarea"),
            'class' => array('label' => __('CSS class', 'ct_theme'), 'default' => '', 'type' => 'input'),
        );
    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-list' ) );
    }
}

new ctParagraphShortcode();