<?php

/**
 * Table shortcode
 */
class ctTableShortcode extends ctShortcode implements ctVisualComposerShortcodeInterface{


    /**
     * Returns name
     * @return string|void
     */
    public function getName()
    {
        return 'Table';
    }

    /**
     * Shortcode name
     * @return string
     */
    public function getShortcodeName()
    {
        return 'table';
    }

    /**
     * Returns shortcode type
     * @return mixed|string
     */

    public function getShortcodeType()
    {
        return self::TYPE_SHORTCODE_ENCLOSING;
    }


    /**
     * Handles shortcode
     * @param $atts
     * @param null $content
     * @return string
     */

    public function handle($atts, $content = null)
    {
        extract(shortcode_atts($this->extractShortcodeAttributes($atts), $atts));
        $mainContainerAtts = array(
            'class' => array(
                ($stripped == 'yes' || $stripped == 'true') ? 'table-responsive' : '',
                $class
            ),
        );

        return do_shortcode('<div ' . $this->buildContainerAttributes($mainContainerAtts, $atts) . '><table class="table '.(($stripped == 'yes' || $stripped == 'true') ? 'table-striped' : '').'">' . $content . '</table></div>');
    }

    /**
     * Returns config
     * @return null
     */
    public function getAttributes()
    {
        return array(
            'content' => array('label' => __('content', 'ct_theme'), 'default' => '', 'type' => 'textarea', 'help' => __("Please enter complete HTML Table markup with &lt;table&gt;..&lt;/table&gt;", 'ct_theme'), 'example' => array($this, 'getExampleContent')),
            'stripped' => array('label' => __('Stripped', 'ct_theme'), 'default' => 'no', 'type' => 'select', 'choices' => array('yes' => __('yes', 'ct_theme'), 'no' => __('no', 'ct_theme')),),
            'class' => array('label' => __('Class', 'ct_theme'), 'default' => '', 'type' => 'input'),
        );
    }

    /**
     * Returns example content
     * @return string
     */
    public function getExampleContent()
    {
        return ' <thead>
                        <tr class="title-important">
                            <th colspan="4">Table</th>
                        </tr>
                        <tr>
                            <th>Duis autem</th>
                            <th>Claritas</th>
                            <th>Investigationes</th>
                            <th>Eodem modo typi eum iriure</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <th>Lorem ipsum dolor sit amet, consectetuer adipiscing</th>
                            <th>Eodem modo typi, qui nunc nobis videntu</th>
                            <th>Lorem ipsum dolor sit amet, consectetuer adipiscing`</th>
                            <th>Typi non habent claritatem insitam; est usus legentis in iis qui facit eorum claritatem. Investigationes demonstraverunt lectores legere me lius quod ii legunt saepius. <a href="#">Claritas es</a></th>
                        </tr>
                        <tr>
                            <th><strong>Lorem ipsum dolor</strong></th>
                            <th>Eodem modo typi</th>
                            <th>Lorem ipsum</th>
                            <th>Typi non habent claritatem insitam; est usus legentis</th>
                        </tr>
                        <tr>
                            <th>Consectetuer adip</th>
                            <th>Qui nunc nbis videntu</th>
                            <th></th>
                            <th>Habent claritatem insitam; est usus legentis in iis qui facit eorum claritatem. Investigationes</th>
                        </tr>
                        <tr>
                            <th><strong>Lorem ipsum dolor</strong></th>
                            <th>Eodem modo typi</th>
                            <th>Lorem ipsum</th>
                            <th>Typi non habent claritatem insitam; est usus legentis</th>
                        </tr>
                        </tbody>
               ';

    }

    /**
     * Returns additional info about VC
     * @return ctVisualComposerInfo
     */
    public function getVisualComposerInfo() {
        return new ctVisualComposerInfo( $this, array( 'icon' => 'fa-table' ) );
    }
}

new ctTableShortcode();