<?php
/**
 * Helper functions for theme
 */


if (!function_exists('ct_get_footer_settings')) {
    /**
     * Setup dynamic footer. This function is automatically called by plugin
     * @see plugin/footer-columns
     * @param $default
     * @return array
     */
    function ct_get_footer_settings($default)
    {
        return array_merge(
            $default,
            array(
                'before_widget' => ' <div class="daycare-widget widget">',
                'after_widget' => '</div>',
                'before_title' => '<h4 class="color-motive uppercase">',
                'after_title' => '</h4>',
                'definitions' => array(
                    '2l' => array(
                        'columns' => array(7, 5)
                    ),
                    '2r' => array(
                        'columns' => array(5, 7)
                    )
                ),
                'numbers' => array(1 => 1, 2 => 2, '2 ' . __("columns (left wide)", 'ct_theme') => '2l', '2 ' . __("columns (right wide)", 'ct_theme') => '2r', 3 => 3),
                'default_number' => 3
            ));
    }
}

/**
 * second timeline featured image
 */
if (class_exists('kdMultipleFeaturedImages')) {

    $args = array(
        'id' => 'featured-image-timeline-2',
        'post_type' => 'timeline', // Set this to post or page
        'labels' => array(
            'name' => __('Timeline thumbnail', 'ct_theme'),
            'set' => __('Set Timeline thumbnail', 'ct_theme'),
            'remove' => __('Remove Timeline thumbnail', 'ct_theme'),
            'use' => __('Use as Timeline thumbnail', 'ct_theme'),
        )
    );

    new kdMultipleFeaturedImages($args);
}

if (!function_exists('ct_timeline_featured_image2_src')) {
    /**
     * Returns product image
     * @param $id
     * @param string $name
     * @param string $size
     * @return string
     */

    function ct_timeline_featured_image2_src($id, $name = 'featured-image-timeline-2', $size = 'timeline_thumbnail')
    {
        $imageUrl = '';
        if (class_exists('kdMultipleFeaturedImages')) {

            $imageUrl = kd_mfi_get_featured_image_url($name, 'timeline', $size, $id);
        }

        if ($imageUrl == '') {
            $imageUrl = ct_get_feature_image_src($id, $size);
        }

        return $imageUrl;
    }
}

if (!function_exists('ct_child_theme_less')) {
    /**
     * Enqueue less file if style.css not compiled
     */
    function ct_child_theme_less()
    {
        if (is_child_theme()) {
            $theme_data = wp_get_theme();
            $main = $theme_data->get_stylesheet_directory_uri() . '/assets/css/style.css';
            if (!file_exists($main)) {
                //compile less file
                $root = $theme_data->get_theme_root_uri();
                $root = str_replace('http://', '', $root);
                $f = explode('/', $root);
                unset($f[0]);

                if ($f[1] !== 'wp-content' && isset($f[2])) {
                    unset($f[0], $f[1]);
                }
                $f = '/' . implode('/', $f);

                wp_enqueue_style('ct-child-theme', $theme_data->get_stylesheet_directory_uri() . '/ct/css.php?less=' . $f . '/' . $theme_data->get_stylesheet() . '/assets/less/style.less', array('ct_theme'), null);
            }
        }
    }
}

add_action('wp_enqueue_scripts', 'ct_child_theme_less');

/**
 * Enqueue scripts
 */
if (!function_exists('ct_theme_scripts')) {
    function ct_theme_scripts()
    {

        wp_register_script('ct_device', CT_THEME_ASSETS . '/js/device.min.js', array('jquery'), null, true);
        wp_enqueue_script('ct_device');

        wp_register_script('hoverIntent', CT_THEME_ASSETS . '/js/hoverIntent.js', array('jquery'), null, true);
        wp_enqueue_script('hoverIntent');


        wp_register_script('modernizr', CT_THEME_ASSETS . '/js/modernizr.custom.js', array('jquery'), null, false);
        wp_enqueue_script('modernizr');

        if (is_page_template('page-onepager.php')) {

            wp_register_script('pagescroller', CT_THEME_ASSETS . '/js/jquery.pagescroller.lite.js', array('jquery'), null, true);
            wp_enqueue_script('pagescroller');

        }


        /*SIDEBAR MASONRY FOR SMALL SCREENS*/
        wp_register_script('masonry', CT_THEME_ASSETS . '/js/masonry.min.js', array('jquery'), null, true);
        wp_enqueue_script('masonry');

        wp_register_script('jquery-ui', CT_THEME_ASSETS . '/js/jquery-ui.custom.min.js', array('jquery'), null, true);
        wp_enqueue_script('jquery-ui');

        wp_register_script('jquery.browser', CT_THEME_ASSETS . '/js/jquery.browser.min.js', array('jquery'), null, true);
        wp_enqueue_script('jquery.browser');


        /*edit table master plugin (food menu)*/
        wp_register_script('edittable-js', CT_THEME_ASSETS . '/plugins/editTable-master/jquery.edittable.min.js', array('jquery'), null, true);
        wp_enqueue_script('edittable-js');
        wp_register_style('edittable-css', CT_THEME_ASSETS . '/plugins/editTable-master/jquery.edittable.min.css');
        wp_enqueue_style('edittable-css');
        /*********/

        if (ct_get_option('general_show_css_animate', 0)) {
            wp_register_script('parallax', CT_THEME_ASSETS . '/js/jquery.parallax.js', array('jquery'), null, true);
            wp_enqueue_script('parallax');

            wp_register_script('ct-animations', CT_THEME_ASSETS . '/js/ctAnimations.js');
            wp_enqueue_script('ct-animations');

            wp_register_script('spritely', CT_THEME_ASSETS . '/js/jquery.spritely.js', array('jquery'), null, true);
            wp_enqueue_script('spritely');
        }

    }
}

add_action('wp_enqueue_scripts', 'ct_theme_scripts');


/**
 * Theme activation
 */

function ct_theme_activation()
{
    $theme_data = wp_get_theme();
    //add crop option
    if (!get_option("medium_crop")) {
        add_option("medium_crop", "1");
    } else {
        update_option("medium_crop", "1");
    }

    //add current version
    add_option('daycare_theme_version', $theme_data->get('Version'));
}

ct_theme_activation();

/**
 * returns video html for video format post
 */
if (!function_exists('ct_post_video')) {
    function ct_post_video($postid, $width = 500, $height = 300)
    {
        $m4v = get_post_meta($postid, 'videoM4V', true);
        $ogv = get_post_meta($postid, 'videoOGV', true);
        $direct = get_post_meta($postid, 'videoDirect', true);
        echo do_shortcode('[video width="' . $width . '" height="' . $height . '" link="' . $direct . '" m4v="' . $m4v . '" ogv="' . $ogv . '"]');
    }
}

/**
 * returns audio html for audio format post
 */
if (!function_exists('ct_post_audio')) {
    function ct_post_audio($postid, $width = 500, $height = 300)
    {
        $mp3 = get_post_meta($postid, 'audioMP3', TRUE);
        $ogg = get_post_meta($postid, 'audioOGA', TRUE);
        $poster = get_post_meta($postid, 'audioPoster', TRUE);
        $audioPosterHeight = get_post_meta($postid, 'audioPosterHeight', TRUE);

        // Calc $height for small images; large will return same value
        //$height = $height * $width / 580;

        echo do_shortcode('[audio height="' . $height . '" width="' . $width . '" mp3="' . $mp3 . '" ogg="' . $ogg . '" poster="' . $poster . '" posterheight="' . $audioPosterHeight . '"]');
    }
}

if (!function_exists('ct_get_the_post_audio')) {
    function ct_get_the_post_audio($postid, $width = 500, $height = 300)
    {
        $mp3 = get_post_meta($postid, 'audioMP3', TRUE);
        $ogg = get_post_meta($postid, 'audioOGA', TRUE);
        $poster = get_post_meta($postid, 'audioPoster', TRUE);
        $audioPosterHeight = get_post_meta($postid, 'audioPosterHeight', TRUE);

        // Calc $height for small images; large will return same value
        //$height = $height * $width / 580;

        return do_shortcode('[audio height="' . $height . '" width="' . $width . '" mp3="' . $mp3 . '" ogg="' . $ogg . '" poster="' . $poster . '" posterheight="' . $audioPosterHeight . '"]');
    }
}

/**
 * show single post title?
 */
if (!function_exists('ct_get_single_post_title')) {
    function ct_get_single_post_title($postType = 'page')
    {
        $show = get_post_meta(get_post() ? get_the_ID() : null, 'show_title', TRUE);

        if ($show == 'global' || $show == '') {
            if ($postType == 'page' && ct_get_option('pages_single_show_title', 1)) {
                return get_the_title();
            }
            if ($postType == 'post' && ct_get_option('posts_single_page_title', '')) {
                return ct_get_option('posts_single_page_title', '');
            }
            if ($postType == 'portfolio' && ct_get_option('portfolio_single_page_title', '')) {
                return ct_get_option('portfolio_single_page_title', '');
            }
            if ($postType == 'event' && ct_get_option('event_single_page_title', '')) {
                return ct_get_option('event_single_page_title', '');
            }

        }
        if ($show == "yes") {
            if ($postType == 'post' && ct_get_option('posts_single_page_title', '')) {
                return ct_get_option('posts_single_page_title', '');
            }
            if ($postType == 'portfolio' && ct_get_option('portfolio_single_page_title', '')) {
                return ct_get_option('portfolio_single_page_title', '');
            }
            if ($postType == 'event' && ct_get_option('event_single_page_title', '')) {
                return ct_get_option('event_single_page_title', '');
            }
        }

        return $show == "yes" ? get_the_title() : '';
    }
}

/**
 * single post/page subtitle?
 */
if (!function_exists('ct_get_single_post_subtitle')) {
    function ct_get_single_post_subtitle($postType = 'page')
    {
        $subtitle = get_post_meta(get_post() ? get_the_ID() : null, 'subtitle', TRUE);
        return $subtitle;
    }
}

/**
 * show single post breadcrumbs?
 */
if (!function_exists('ct_show_single_post_breadcrumbs')) {
    function ct_show_single_post_breadcrumbs($postType = 'page')
    {
        $show = get_post_meta(get_post() ? get_the_ID() : null, 'show_breadcrumbs', TRUE);
        if ($show == 'global' || $show == '') {
            if ($postType == 'page') {
                return ct_get_option('pages_single_show_breadcrumbs', 1);
            }
            if ($postType == 'post') {
                return ct_get_option('posts_single_show_breadcrumbs', 1);
            }
            if ($postType == 'portfolio') {
                return ct_get_option('portfolio_single_show_breadcrumbs', 1);
            }
            if ($postType == 'event') {
                return ct_get_option('event_single_show_breadcrumbs', 1);
            }
        }
        return $show == "yes";
    }
}

/**
 * show index post title?
 * todo: get_current_blog_id() zamiast ct_get_option
 */
if (!function_exists('ct_get_index_post_title')) {
    function ct_get_index_post_title($postType = 'page')
    {
        $show = get_post_meta(get_post() ? get_the_ID() : null, 'show_title', TRUE);
        if (is_search()) {
            return __('Search results', 'ct_theme');
        }
        if ($show == 'global' || $show == '') {
            if ($postType == 'post' && ct_get_option('posts_index_show_p_title', 1)) {
                $id = get_option('page_for_posts');
                $page = get_post($id);
                return $page ? $page->post_title : '';
            }
            if ($postType == 'portfolio' && ct_get_option('portfolio_index_show_p_title', 1)) {
                $id = ct_get_option('portfolio_index_page');
                $page = get_post($id);
                return $page ? $page->post_title : '';
            }
            if ($postType == 'faq' && ct_get_option('faq_index_show_title', 1)) {
                $id = ct_get_option('faq_index_page');
                $page = get_post($id);
                return $page ? $page->post_title : '';
            }
        }
        return $show == "yes" ? get_the_title() : '';
    }
}

/**
 * single post/page subtitle?
 */
if (!function_exists('ct_get_index_post_subtitle')) {
    function ct_get_index_post_subtitle($postType = 'page')
    {
        if (is_search()) {
            return '';
        }
        if ($postType == 'post' && ct_get_option('posts_index_show_p_title', 1)) {
            $id = get_option('page_for_posts');
            $subtitle = $id ? get_post_meta($id, 'subtitle', TRUE) : '';
            return $subtitle;
        }

        $subtitle = get_post_meta(get_post() ? get_the_ID() : null, 'subtitle', TRUE);
        return $subtitle;
    }
}


/**
 * show index post breadcrumbs?
 */
if (!function_exists('ct_show_index_post_breadcrumbs')) {
    function ct_show_index_post_breadcrumbs($postType = 'page')
    {
        $show = get_post_meta(get_post() ? get_the_ID() : null, 'show_breadcrumbs', TRUE);
        if ($show == 'global' || $show == '') {
            if ($postType == 'post') {
                return ct_get_option('posts_index_show_breadcrumbs', 1);
            }
            if ($postType == 'portfolio') {
                return ct_get_option('portfolio_index_show_breadcrumbs', 1);
            }
            if ($postType == 'faq') {
                return ct_get_option('faq_index_show_breadcrumbs', 1);
            }
        }
        return $show == "yes";
    }
}


/**
 * add menu shadow ?
 */
if (!function_exists('ct_add_menu_shadow')) {
    function ct_add_menu_shadow()
    {
        return ct_get_option('style_menu_shadow', 'no') == 'yes';
    }
}


/**
 * slider code
 */
if (!function_exists('ct_slider_code')) {
    function ct_slider_code()
    {
        if (is_home()) {
            $id = get_option('page_for_posts');
            $slider = $id ? get_post_meta($id, 'slider', TRUE) : '';
        } else {
            $slider = get_post_meta(get_post() ? get_the_ID() : null, 'slider', TRUE);
        }
        return $slider;
    }
}

/**
 * image size for posts
 */
if (!function_exists('ct_show_single_post_image_size')) {
    function ct_show_single_post_image_size()
    {
        $show = get_post_meta(get_post() ? get_the_ID() : null, 'image_size', TRUE);
        if ($show == 'global' || $show == '') {
            return ct_get_option('post_featured_image_type', 'full');
        }
        return $show;
    }
}

/**
 * socials code
 */
if (!function_exists('ct_socials_code')) {
    function ct_socials_code($style = null, $tooltip_placement = null, $align = null, $header = null)
    {
        $socials = array(
            'bitbucket',
            'dribbble',
            'dropbox',
            'facebook',
            'flickr',
            'foursquare',
            'github',
            'gittip',
            'google',
            'instagram',
            'linkedin',
            'pinterest',
            'Renren',
            'rss',
            'skype',
            'stack_exchange',
            'stack_overf',
            'tumblr',
            'twitter',
            'vimeo',
            'vkontakte',
            'Weibo',
            'xing',
            'youtube',
            'email'
        );
        $params = $style ? 'style="' . $style . '" ' : '';
        $params .= $tooltip_placement ? 'tooltip_placement="' . $tooltip_placement . '" ' : '';
        $params .= $align ? 'align="' . $align . '" ' : '';
        $params .= $header ? 'header="' . $header . '" ' : '';
        foreach ($socials as $key) {

            if (ct_get_option($key)) {
                $value = ct_get_option($key);
                $value = ($key == 'rss' && ct_get_option($key) == '1') ? 'yes' : $value;
                $value = ($key == 'rss' && ct_get_option($key) == '0') ? 'no' : $value;
                $params .= $key . '="' . ct_get_option($key) . '" ';
            }
        }

        $socials = '[socials ' . $params . ']';
        return do_shortcode($socials);
    }
}

function translate_date_format($format) {
    if (function_exists('icl_translate'))
        $format = icl_translate('Formats', $format, $format);
    return $format;
}
add_filter('option_date_format', 'translate_date_format');


if (!function_exists('ct_get_post_short_month_name')) {
    function ct_get_post_short_month_name()
    {
        //Works with language
        $time = mktime(0, 0, 0, get_the_time('m'));
        $short_month_name = strftime("%B", $time);
        $short_month_name = __($short_month_name);
        $short_month_name = mb_substr($short_month_name,0,3);
        return $short_month_name;
    }
}

if (!function_exists('ct_get_post_day')) {
    function ct_get_post_day()
    {
        $day = get_the_time('d');
        return $day;
    }
}

if (!function_exists('ct_get_comments_count')) {
    function ct_get_comments_count()
    {
        $commentsCount = wp_count_comments(get_the_ID())->approved;
        return $commentsCount;
    }
}

if (!function_exists('ct_get_blog_item_title')) {
    function ct_get_blog_item_title()
    {
        $postTitle = get_the_title();
        $custom = get_post_custom(get_the_ID());


        if (!isset($custom['show_title'][0])) {
            $custom['show_title'][0] = 'global';
        }


        if (isset($custom['show_title'][0])) {
            if (ct_get_option("posts_single_show_title", 1) && $custom['show_title'][0] == 'global') {
                return $postTitle;

            } else {
                return '';
            }
        }

        if (isset($custom['show_title'][0]) && $custom['show_title'][0] == 'yes') {
            return $postTitle;
        }

        return '';
    }
}

if (!function_exists('ct_new_excerpt_more')) {
    function ct_new_excerpt_more($more)
    {
        return '';
    }
}
add_filter('ct_excerpt_more', 'new_excerpt_more');


/* Custom Excerpt length */
function ct_new_excerpt_length($length)
{
    return (ct_get_option("posts_show_index_as", 1) == 'blog_list') ? 60 : 20;
}

add_filter('excerpt_length', 'ct_new_excerpt_length', 999);


if (!function_exists('ct_is_location_contains_menu')) {
    function ct_is_location_contains_menu($location = null)
    {
        $menus = (get_nav_menu_locations());
        return isset($menus[$location]) && is_object(wp_get_nav_menu_object($menus[$location]));
    }
}

if (!function_exists('ct_get_comments_number')) {
    /**
     *
     */
    function ct_get_comments_number()
    {
        comments_number(__('No Comments', 'ct_theme'), '1 ' . __('Comment', 'ct_theme'), '% ' . __('Comments', 'ct_theme'));
    }
}

/* Tags Cloud - custom class */
add_filter('the_tags', 'ct_tagCloudClass');
function ct_tagCloudClass($list)
{
    $list = str_replace('<a', '<li><a ', $list);
    $list = str_replace('</a>', '</a></li> ', $list);

    return $list;
}

/*add class to Author Box image*/
function ct_mytheme_get_avatar($avatar, $id_or_email, $size)
{
    $avatar = str_replace('<img', '<img class="media-object"', $avatar);
    return $avatar;
}

add_filter('get_avatar', 'ct_mytheme_get_avatar', 10, 3);


/*add class to post-single navigation*/
add_filter('next_post_link', 'ct_post_link_attributes');
add_filter('previous_post_link', 'ct_post_link_attributes');
function ct_post_link_attributes($output)
{
    $injection = 'class="navigation-blog"';
    return str_replace('<a href=', '<a ' . $injection . ' href=', $output);
}


if (!function_exists('ct_is_browser_type')) {
    function ct_is_browser_type($type = NULL)
    {
        $user_agent = strtolower($_SERVER['HTTP_USER_AGENT']);
        if ($type == 'bot') {
            if (preg_match("/googlebot|adsbot|yahooseeker|yahoobot|msnbot|watchmouse|pingdom\.com|feedfetcher-google/", $user_agent)) {
                return true;
            }
        } else if ($type == 'browser') {
            if (preg_match("/mozilla\/|opera\//", $user_agent)) {
                return true;
            }
        } else if ($type == 'mobile') {
            if (preg_match("/phone|iphone|itouch|ipod|symbian|android|htc_|htc-|palmos|blackberry|opera mini|iemobile|windows ce|nokia|fennec|hiptop|kindle|mot |mot-|webos\/|samsung|sonyericsson|^sie-|nintendo/", $user_agent)) {
                return true;
            } else if (preg_match("/mobile|pda;|avantgo|eudoraweb|minimo|netfront|brew|teleca|lg;|lge |wap;| wap /", $user_agent)) {
                return true;
            }
        }
        return false;
    }
}


if (!function_exists('ct_get_excerpt_by_id')) {
    function ct_get_excerpt_by_id($post_id, $lenght = 10, $after_text = '&#8230;')
    {
        $the_post = get_post($post_id);
        $the_excerpt = $the_post->post_content;
        $excerpt_length = $lenght;

        $the_excerpt = strip_tags(strip_shortcodes($the_excerpt));
        $words = explode(' ', $the_excerpt, $excerpt_length + 1);

        if (count($words) > $excerpt_length) {
            array_pop($words);
            array_push($words, $after_text);
            $the_excerpt = implode(' ', $words);
        }

        $the_excerpt = '<p>' . $the_excerpt . '</p>';
        return $the_excerpt;
    }
}
/*
function ct_get_excerpt_by_id($post_id, $lenght = 10, $after_text = '&#8230;')
    {
        $the_post = get_post($post_id);
        $the_excerpt = $the_post->post_excerpt;
        if ('' !==$the_excerpt) {
            return '<p>' . strip_tags(strip_shortcodes($the_excerpt)) . '</p>';
        }else{
            $the_excerpt = $the_post->post_content;
        }

        $extended = get_extended($the_excerpt);

        //adds #more-postid to link
        $ismore = @strpos($the_post->post_content, '<!--more-->');
        if ($ismore) {
            add_filter('ct_more_id', 'ct_add_more_id');
            return do_shortcode($extended['main']);
        }

        the_content();
        return'';
        //return do_shortcode(get_the_content());
    }
*/

if (!function_exists('ctGetTwitterShareBtn')) {
    function ctGetTwitterShareBtn($text = '', $url = '', $tooltipText = '', $buttontText = '', $iconClass = 'fa fa-twitter', $target = '_blank', $class = 'btn btn-primary uppercase', $data_toggle = 'tooltip', $data_placement = 'top', $title = '')
    {
        $url = !empty($url) ? '%0A' . $url : '';
        $text = strip_tags(strip_shortcodes($text));
        $html = ' <a href="https://twitter.com/home?status=' . urlencode($text) . $url . '" target="' . $target . '" class="' . $class . '" data-toggle="' . $data_toggle . '" data-placement="' . $data_placement . '" title="' . $title . '" data-original-title="' . $tooltipText . '">' . $buttontText . ' <i class="' . $iconClass . '"></i></a>';
        return $html;
    }
}

if (!function_exists('ctGetFbShareBtn')) {
    function ctGetFbShareBtn($buttontText = 'share', $tooltipText = '', $data_placement = 'top', $iconClass = 'fa fa-facebook', $class = 'btn btn-primary uppercase', $target = '_blank', $data_toggle = 'tooltip', $afterUrl = '')
    {
        return '<a target="' . $target . '" href="http://www.facebook.com/sharer/sharer.php?u=' . get_permalink(get_the_id()) . $afterUrl . '" class="' . $class . '" data-toggle="' . $data_toggle . '" data-placement="' . $data_placement . '"  data-original-title="' . $tooltipText . '">' . $buttontText . ' <i class="' . $iconClass . '"></i></a>';
    }
}


if (!function_exists('ctAddthisButton')) {
    function ctAddthisButton($inlineStyle = '')

    {
        $inlineStyle = !empty($inlineStyle) ? 'style="' . $inlineStyle . '"' : '';
        return '

    <div class="addthis_toolbox addthis_default_style addthis_32x32_style" ' . $inlineStyle . '>
        <a class="addthis_button_compact"></a>
        <a class="addthis_counter addthis_bubble_style"></a>
    </div>
    <script type="text/javascript">var addthis_config = {"data_track_addressbar":false};</script>
    <script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-5356400e5c4b6257"></script>
    ';
    }
}


if (!function_exists('ct_get_attributes')) {
    function ct_get_attributes($atts = array())
    {
        $str = '';
        if (!empty($atts)) {
            foreach ($atts as $key => $value) {
                $str .= $key . '=' . '"' . esc_attr($value) . '" ';
            }
            return $str;
        } else {
            return '';
        }
    }
}


function ct_get_next_post()
{
    $next_post = get_next_post();

    if (is_object($next_post)) {
        return array(
            'image' => ct_get_feature_image_src($next_post->ID, 'featured_image'),
            'title' => $next_post->post_title,
            'excerpt' => ct_get_excerpt_by_id($next_post->ID, 6, '')
        );
    } else {
        return null;
    }
}


function ct_get_previous_post()
{
    $previous_post = get_previous_post();

    if (is_object($previous_post)) {
        return array(
            'image' => ct_get_feature_image_src($previous_post->ID, 'featured_image'),
            'title' => $previous_post->post_title,
            'excerpt' => ct_get_excerpt_by_id($previous_post->ID, 6, '')
        );
    } else {
        return null;
    }
}

//modify native search WP widget
if (!function_exists('ct_update_widget')) {
    function ct_update_widget($params)
    {
        if (isset($params[0]) && $params[0]['widget_name'] == "Search") {
            $injection = 'search-widget ';
            $params[0]['before_widget'] = str_replace('<div class="shadow-box', '<div class="shadow-box ' . $injection, $params[0]['before_widget']);
        }


        if (isset($params[0]) && $params[0]['widget_name'] == "Archives") {
            $injection = 'widget-archives ';
            $params[0]['before_widget'] = str_replace('<div class="shadow-box', '<div class="shadow-box ' . $injection, $params[0]['before_widget']);
        }

        return $params;
    }
}
add_filter('dynamic_sidebar_params', 'ct_update_widget');


include_once(dirname(__FILE__) . '/shortcodes/ctBigMenuContainer.php');
include_once(dirname(__FILE__) . '/shortcodes/ctNavigation.class.php');
include_once(dirname(__FILE__) . '/shortcodes/ctScrollBoxFormatter.class.php');
include_once(dirname(__FILE__) . '/shortcodes/ctGalleryFormatter.class.php');
include_once(dirname(__FILE__) . '/shortcodes/ctSocialsMetaFields.class.php');
include_once(dirname(__FILE__) . '/shortcodes/ctMealPlan.class.php');


//remove gallery body class
add_filter('body_class', 'custom_body_class', 10, 2);

function custom_body_class($classes)
{
    //var_dump($classes);
    $key = array_search('gallery', $classes);
    if ($key !== false) {
        unset($classes[$key]);
    }

    $key = array_search('programs', $classes);
    if ($key !== false) {
        unset($classes[$key]);
    }



    unset($classes['withAnimation']);

    return $classes;
}


if (!function_exists('ct_footer_class')) {
    function ct_footer_class($class)
    {
        $class = 'type1';
        return $class;
    }
}
add_filter('footer_class', 'ct_footer_class');


add_filter('ct.vc_column.apply_section', 'ctRemoveVcSection');
function ctRemoveVcSection()
{
    if (is_page_template('page-onepager.php')) {
        return true;
    } else {
        return false;
    }
}

add_filter('ct.vc_row.add_container_before', 'ctAddContainer');
function ctAddContainer()
{
    if (is_page_template('page-onepager.php')) {
        return true;
    } else {
        return false;
    }
}


if (!function_exists('ct_esc_attr')) {
    /**
     * @param $attribute
     * @param $value
     * @param null $default
     * @return string
     */
    function ct_esc_attr($attribute, $value, $default = null)
    {
        if (!isset($attribute) || empty($attribute)) {
            return '';
        } else {

            if (!isset($value) || empty($value)) {
                if (!isset($default) || empty($default)) {
                    return '';
                } else {
                    return htmlspecialchars($attribute . '=' . esc_attr($default) . '');
                }
            } else {
                return htmlspecialchars($attribute . '=' . esc_attr($value) . '');
            }
        }
    }
}


if (!function_exists('ct_esc_attrs')) {
    /**
     * @param array $atts
     * @return string
     */
    function ct_esc_attrs($atts = array())
    {

        if (!is_array($atts) && empty($atts)) {
            return '';
        } else {
            $counter = 0;
            $attsHtml = '';


            foreach ($atts as $key => $value) {
                if (!isset($value['attr']) || empty($value['attr'])) {
                    continue;
                } else {
                    //var_dump($value['attr']);
                    $attribute = $value['attr'];
                }
                if (!isset($value['val']) || empty($value['val'])) {

                    if (!isset($value['default']) || empty($value['default'])) {

                        continue;
                    } else {
                        $default = $value['default'];
                        $value = null;
                    }
                } else {
                    $value = $value['val'];

                }
                //var_dump($value);exit();
                if (!isset($attribute) || empty($attribute)) {
                    return '';
                } else {
                    if (!isset($value) || empty($value)) {
                        //exit();
                        if (!isset($default) || empty($default)) {

                            return '';
                        } else {

                            $attsHtml .= ($counter == 0 ? ' ' : '') . $attribute . '="' . esc_attr($default) . '"' . ($counter < count($atts) ? ' ' : '');
                            $counter++;
                        }
                    } else {

                        $attsHtml .= ($counter == 0 ? ' ' : '') . $attribute . '="' . esc_attr($value) . '"' . ($counter < count($atts) ? ' ' : '');
                        $counter++;
                    }
                }
            }
            return $attsHtml;
        }
    }
}


if (!function_exists('ct_import_demo_blocks')) {

    /**
     * Blocks names
     *
     * @param $dirs
     *
     * @return array
     */

    function ct_import_demo_blocks($blocks, $dirs)
    {
        $logoBase = CT_THEME_ASSETS . '/shortcode/1click';

        $groups = array();
        foreach ($dirs as $d) {
            $name = basename($d);
            $ex = explode('-', $name);
            if (!isset($ex[1])) {
                throw new Exception("Invalid 1 Click Import names");
            }

            if (!isset($groups[$ex[1]])) {
                $groups[$ex[1]] = array(
                    'name' => ucfirst($ex[1]),
                    'logo' => $logoBase . '/' . $ex[1] . '.png',
                    'buttons' => array()
                );
            }

            $groups[$ex[1]]['buttons'][] = array('dir' => $name, 'label' => $ex[0]);
        }

        return array_merge($blocks, $groups);
    }

}
add_filter('ct_import.options.demos.blocks', 'ct_import_demo_blocks', 10, 2);


if (!function_exists('ct_get_id_from_slug')) {
    function ct_get_id_from_slug($slug = null, $postType = 'post')
    {
        if (is_string($slug)) {
            $args = array(
                'name' => $slug,
                'post_type' => $postType,
                'post_status' => 'publish',
                'showposts' => 1,
                'caller_get_posts' => 1
            );
            $posts = get_posts($args);
            if ($posts) {
                return $posts[0]->ID;
            }
        }
    }
}



