<?php
require_once CT_THEME_LIB_DIR . '/types/ctTypeBase.class.php';


/**
 * Custom type - Activity
 */
class ctActivityType extends ctTypeBase
{


    /**
     * Slug option name
     */

    const OPTION_SLUG = 'activity_index_slug';

    /**
     * Initializes activity
     * @return mixed|void
     */

    public function init()
    {
        add_action('template_redirect', array($this, 'activityContextFixer'));

        $this->registerType();
        $this->registerTaxonomies();

        add_action("admin_init", array($this, "addMetaBox"));

        /** @var $NHP_Options NHP_Options */
        global $NHP_Options;
        //add options listener for license
        add_action('nhp-opts-options-validate-' . $NHP_Options->args['opt_name'], array($this, 'handleSlugOptionSaved'));
    }

    /**
     * Adds meta box
     */

    public function addMetaBox()
    {
        add_meta_box("activity-meta", __("Activity settings", 'ct_theme'), array($this, "activityMeta"), "activity", "normal", "high");
        add_meta_box("activity-meta-soc", __("Socials settings", 'ct_theme'), array($this, "socialsMeta"), "activity", "normal", "high");

        add_action('save_post', array($this, 'saveDetails'));
    }

    /**
     * Fixes proper menu state
     */

    public function activityContextFixer()
    {
        if (get_query_var('post_type') == 'activity') {
            global $wp_query;
            $wp_query->is_home = false;
        }
        if (get_query_var('taxonomy') == 'activity_category') {
            global $wp_query;
            $wp_query->is_404 = true;
            $wp_query->is_tax = false;
            $wp_query->is_archive = false;
        }
    }

    /**
     * Register type
     */

    protected function registerType()
    {
        $typeData = $this->callFilter('pre_register_type', array(
            'labels' => array(
                'name' => _x('Activity', 'post type general name', 'ct_theme'),
                'singular_name' => _x('Activity item', 'post type singular name', 'ct_theme'),
                'add_new' => _x('Add New', 'activity', 'ct_theme'),
                'add_new_item' => __('Add New Activity', 'ct_theme'),
                'edit_item' => __('Edit Activity', 'ct_theme'),
                'new_item' => __('New Activity', 'ct_theme'),
                'view_item' => __('View Activity', 'ct_theme'),
                'search_items' => __('Search Activities', 'ct_theme'),
                'not_found' => __('No Activities found', 'ct_theme'),
                'not_found_in_trash' => __('No Activity found in Trash', 'ct_theme'),
                'parent_item_colon' => '',
                'menu_name' => __('Activities', 'ct_theme'),
            ),
            'singular_label' => __('Activities', 'ct_theme'),
            'public' => true,
            'publicly_queryable' => true,
            'exclude_from_search' => false,
            'show_ui' => true,
            'show_in_menu' => true,
            //'menu_position' => 20,
            'menu_icon' => 'dashicons-nametag',
            'capability_type' => 'post',
            'hierarchical' => false,
            'supports' => array('title', 'editor', 'thumbnail', 'page-attributes'),
            'has_archive' => false,
            'rewrite' => array('slug' => $this->getPermalinkSlug(), 'with_front' => true, 'pages' => true, 'feeds' => false),
            'query_var' => false,
            'can_export' => true,
            'show_in_nav_menus' => true,
            'taxonomies' => array('post_tag')
        ));

        register_post_type('activity', $typeData);
        $this->callHook('post_register_type');
    }

    /**
     * Returns permalink slug
     * @return string
     */

    protected function getPermalinkSlug()
    {
        // Rewriting Permalink Slug
        $permalink_slug = ct_get_option('activity', 'activity');
        if (empty($permalink_slug)) {
            $permalink_slug = 'activity';
        }

        return $permalink_slug;
    }

    /**
     * Gets hook name
     * @return string
     */
    protected function getHookBaseName()
    {
        return 'ct_activity';
    }

    /**
     * Creates taxonomies
     */

    protected function registerTaxonomies()
    {
        $data = $this->callFilter('pre_register_taxonomies', array(
            'hierarchical' => true,
            'labels' => array(
                'name' => _x('Activity Categories', 'taxonomy general name', 'ct_theme'),
                'singular_name' => _x('Activity Category', 'taxonomy singular name', 'ct_theme'),
                'search_items' => __('Search Categories', 'ct_theme'),
                'popular_items' => __('Popular Categories', 'ct_theme'),
                'all_items' => __('All Categories', 'ct_theme'),
                'parent_item' => null,
                'parent_item_colon' => null,
                'edit_item' => __('Edit Activity Category', 'ct_theme'),
                'update_item' => __('Update Activity Category', 'ct_theme'),
                'add_new_item' => __('Add New Activity Category', 'ct_theme'),
                'new_item_name' => __('New Activity Category Name', 'ct_theme'),
                'separate_items_with_commas' => __('Separate Activity category with commas', 'ct_theme'),
                'add_or_remove_items' => __('Add or remove Activity category', 'ct_theme'),
                'choose_from_most_used' => __('Choose from the most used Activity category', 'ct_theme'),
                'menu_name' => __('Categories', 'ct_theme'),
            ),
            'public' => false,
            'show_in_nav_menus' => false,
            'show_ui' => true,
            'show_tagcloud' => false,
            'query_var' => 'activity_category',
            'rewrite' => false,

        ));
        register_taxonomy('activity_category', 'activity', $data);
        $this->callHook('post_register_taxonomies');
    }


    /**
     * Gets display method for activity
     * @param array $meta - post meta
     * @return null|string
     */
    public static function getMethodFromMeta($meta)
    {
        $method = isset($meta['display_method']) ? $meta['display_method'][0] : null;
        /*
        if (!$method) {
            $method = isset($meta['video'][0]) && trim($meta['video'][0]) ? 'video' : 'image';
        }
        */
        return $method;
    }

    /**
     * Handles rebuild
     */

    public function handleSlugOptionSaved($newValues)
    {
        $currentSlug = $this->getPermalinkSlug();
        //rebuild rewrite if new slug
        if (isset($newValues[self::OPTION_SLUG]) && ($currentSlug != $newValues[self::OPTION_SLUG])) {
            $this->callHook('pre_slug_option_saved', array('current_slug' => $currentSlug, 'new_slug' => $newValues[self::OPTION_SLUG]));

            //clean rewrite to refresh it
            delete_option('rewrite_rules');
        }
    }


    /**
     * Draw s activity meta
     */

    public function activityMeta()
    {
        global $post;
        $custom = get_post_custom($post->ID);

        $summary = isset($custom["summary"][0]) ? $custom["summary"][0] : "";
        ?>


        <p>
            <label for="summary"><?php _e('Summary', 'ct_theme') ?></label>
            <textarea id="summary" class="regular-text" name="summary" cols="100"
                      rows="5"><?php echo esc_html($summary); ?></textarea>
        <p class="howto"><?php _e("Summary will be show on index page", 'ct_theme') ?></p>

    <?php
    }


    public function socialsMeta()
    {
        global $post;
        $custom = get_post_custom($post->ID);
        $socials = new ctSocialsMetaFields();
        $socials->theFields($custom);
    }

    /**
     * activity template settings
     */

    public function activityTemplateMeta()
    {
        global $post;
        $custom = get_post_custom($post->ID);

    }


    public function saveDetails()
    {
        global $post;

        $fields = array(
            'summary',
        );
        $fields = array_merge(ctSocialsMetaFields::getFieldsArray(), $fields);

        foreach ($fields as $field) {
            if (isset($_POST[$field])) {
                update_post_meta($post->ID, $field, $_POST[$field]);
            }
        }
    }
}

new ctActivityType();