<?php
require_once CT_THEME_LIB_DIR . '/types/ctTypeBase.class.php';


/**
 * Custom type - ctTestimonialType
 */
class ct_header_block extends ctTypeBase
{


    /**
     * Slug option name
     */

    const OPTION_SLUG = 'ct_header_block_index_slug';

    /**
     * Initializes Bock
     * @return mixed|void
     */

    public function init()
    {
        add_action('template_redirect', array($this, 'ct_header_blockContextFixer'));

        $this->registerType();
        //$this->registerTaxonomies();

        add_action("admin_init", array($this, "addMetaBox"));

        /** @var $NHP_Options NHP_Options */
        global $NHP_Options;
        //add options listener for license
        add_action('nhp-opts-options-validate-' . $NHP_Options->args['opt_name'], array($this, 'handleSlugOptionSaved'));
    }

    /**
     * Adds meta box
     */

    public function addMetaBox()
    {
        //add_meta_box("ct_header_block-meta", __("Header Block settings", 'ct_theme'), array($this, "ct_header_block"), "ct", "normal", "high");
        add_action('save_post', array($this, 'saveDetails'));
    }

    /**
     * Fixes proper menu state
     */

    public function ct_header_blockContextFixer()
    {
        if (get_query_var('post_type') == 'ct_header_block') {
            global $wp_query;
            $wp_query->is_home = false;
        }
        if (get_query_var('taxonomy') == 'ct_header_block_category') {
            global $wp_query;
            $wp_query->is_404 = true;
            $wp_query->is_tax = false;
            $wp_query->is_archive = false;
        }
    }

    /**
     * Register type
     */

    protected function registerType()
    {
        $typeData = $this->callFilter('pre_register_type', array(
            'labels' => array(
                'name' => _x('Header Block', 'post type general name', 'ct_theme'),
                'singular_name' => _x('Header Block Item', 'post type singular name', 'ct_theme'),
                'add_new' => _x('Add New', 'Header Block', 'ct_theme'),
                'add_new_item' => __('Add New Header Block', 'ct_theme'),
                'edit_item' => __('Edit Header Block', 'ct_theme'),
                'new_item' => __('New Header Block', 'ct_theme'),
                'view_item' => __('View Header Block', 'ct_theme'),
                'search_items' => __('Search Header Blocks', 'ct_theme'),
                'not_found' => __('No Header Blocks found', 'ct_theme'),
                'not_found_in_trash' => __('No Header Blocks found in Trash', 'ct_theme'),
                'parent_item_colon' => '',
                'menu_name' => __('Header Blocks', 'ct_theme'),
            ),
            'singular_label' => __('Header Block', 'ct_theme'),
            'public' => true,
            'publicly_queryable' => true,
            'exclude_from_search' => false,
            'show_ui' => true,
            'show_in_menu' => true,
            //'menu_position' => 20,
            'menu_icon' => 'dashicons-media-code',
            'capability_type' => 'post',
            'hierarchical' => false,
            'supports' => array('title', 'editor', 'thumbnail', 'page-attributes'),
            'has_archive' => false,
            'rewrite' => array('slug' => $this->getPermalinkSlug(), 'with_front' => true, 'pages' => true, 'feeds' => false),
            'query_var' => false,
            'can_export' => true,
            'show_in_nav_menus' => false,
            'taxonomies' => array()
        ));

        register_post_type('ct_header_block', $typeData);
        $this->callHook('post_register_type');
    }

    /**
     * Returns permalink slug
     * @return string
     */

    protected function getPermalinkSlug()
    {
        // Rewriting Permalink Slug
        $permalink_slug = ct_get_option('th', 'ct_header_block');
        if (empty($permalink_slug)) {
            $permalink_slug = 'block';
        }

        return $permalink_slug;
    }

    /**
     * Gets hook name
     * @return string
     */
    protected function getHookBaseName()
    {
        return 'ct_header_block';
    }




    /**
     * Handles rebuild
     */

    public function handleSlugOptionSaved($newValues)
    {
        $currentSlug = $this->getPermalinkSlug();
        //rebuild rewrite if new slug
        if (isset($newValues[self::OPTION_SLUG]) && ($currentSlug != $newValues[self::OPTION_SLUG])) {
            $this->callHook('pre_slug_option_saved', array('current_slug' => $currentSlug, 'new_slug' => $newValues[self::OPTION_SLUG]));

            //clean rewrite to refresh it
            delete_option('rewrite_rules');
        }
    }


    /**
     * Draw s Testimonial meta
     */

    public function ct_header_blockMeta()
    {
        global $post;
        $custom = get_post_custom($post->ID);



        ?>


    <?php
    }

    /**
     * testimonial_footer template settings
     */

    public function testimonialTemplateMeta()
    {
        global $post;
        $custom = get_post_custom($post->ID);

    }


    public function saveDetails()
    {
        global $post;

        $fields = array(

            'job_position',
            'phone',
            'email',
        );
        foreach ($fields as $field) {
            if (isset($_POST[$field])) {
                update_post_meta($post->ID, $field, $_POST[$field]);
            }
        }
    }
}

new ct_header_block();