<?php
require_once CT_THEME_LIB_DIR . '/types/ctTypeBase.class.php';


/**
 * Custom type - Menu
 */
class ctMealPlanType extends ctTypeBase
{

    const POST_TYPE = 'ctMealPlan';

    /**
     * Slug option name
     */

    const OPTION_SLUG = 'ctMealPlan_index_slug';

    /**
     * Initializes ctMealPlan
     * @return mixed|void
     */

    public function init()
    {
        add_action('template_redirect', array($this, 'ctMealPlanContextFixer'));

        $this->registerType();
        $this->registerTaxonomies();

        add_action("admin_init", array($this, "addMetaBox"));

        /** @var $NHP_Options NHP_Options */
        global $NHP_Options;
        //add options listener for license
        add_action('nhp-opts-options-validate-' . $NHP_Options->args['opt_name'], array($this, 'handleSlugOptionSaved'));
    }

    /**
     * Adds meta box
     */

    public function addMetaBox()
    {
        add_meta_box("ctMealPlanEditMeta", __("Edit meal plan", 'ct_theme'), array($this, "ctMealPlanEditMeta"), "ctMealPlan", "normal", "high");
        //add_meta_box("ctMealPlanWeekMeta", __("Select week", 'ct_theme'), array($this, "ctMealPlanWeekMeta"), "ctMealPlan", "normal", "");

        add_action('save_post', array($this, 'saveDetails'));
    }

    /**
     * Fixes proper menu state
     */

    public function ctMealPlanContextFixer()
    {
        if (get_query_var('post_type') == 'ctMealPlan') {
            global $wp_query;
            $wp_query->is_home = false;
        }
        if (get_query_var('taxonomy') == 'ctMealPlan_category') {
            global $wp_query;
            $wp_query->is_404 = true;
            $wp_query->is_tax = false;
            $wp_query->is_archive = false;
        }
    }

    /**
     * Register type
     */

    protected function registerType()
    {
        $typeData = $this->callFilter('pre_register_type', array(
            'labels' => array(
                'name' => _x('Meal Plan', 'post type general name', 'ct_theme'),
                'singular_name' => _x('Meal Plan item', 'post type singular name', 'ct_theme'),
                'add_new' => _x('Add New', 'Meal Plan', 'ct_theme'),
                'add_new_item' => __('Add new Meal Plan Item', 'ct_theme'),
                'edit_item' => __('Edit Meal Plan Item', 'ct_theme'),
                'new_item' => __('New Weekly Meal Plan', 'ct_theme'),
                'view_item' => __('View Meal Plan Item', 'ct_theme'),
                'search_items' => __('Search Meal Plan', 'ct_theme'),
                'not_found' => __('No Meal Plan items found', 'ct_theme'),
                'not_found_in_trash' => __('No Meal Plan found in Trash', 'ct_theme'),
                'parent_item_colon' => '',
                'menu_name' => __('Weekly Meal Plan', 'ct_theme'),
            ),
            'singular_label' => __('Weekly Meal Plan', 'ct_theme'),
            'public' => true,
            'publicly_queryable' => true,
            'exclude_from_search' => false,
            'show_ui' => true,
            'show_in_menu' => true,
            //'menu_position' => 20,
            'menu_icon' => 'dashicons-editor-paste-word',
            'capability_type' => 'post',
            'hierarchical' => false,
            'supports' => array('title', 'editor', 'thumbnail', 'page-attributes'),
            'has_archive' => false,
            'rewrite' => array('slug' => $this->getPermalinkSlug(), 'with_front' => true, 'pages' => true, 'feeds' => false),
            'query_var' => false,
            'can_export' => true,
            'show_in_nav_menus' => true,
            'taxonomies' => array('post_tag')
        ));

        register_post_type(self::POST_TYPE, $typeData);
        $this->callHook('post_register_type');
    }

    /**
     * Returns permalink slug
     * @return string
     */

    protected function getPermalinkSlug()
    {
        // Rewriting Permalink Slug
        $permalink_slug = ct_get_option('ctMealPlan', 'meal_plan');
        if (empty($permalink_slug)) {
            $permalink_slug = 'menu';
        }

        return $permalink_slug;
    }

    /**
     * Gets hook name
     * @return string
     */
    protected function getHookBaseName()
    {
        return 'ctMealPlan';
    }

    /**
     * Creates taxonomies
     */

    protected function registerTaxonomies()
    {


        $data = $this->callFilter('pre_register_taxonomies', array(
            'hierarchical' => true,
            'labels' => array(
                'name' => _x('Meal Plan Categories', 'taxonomy general name', 'ct_theme'),
                'singular_name' => _x('Meal Plan Category', 'taxonomy singular name', 'ct_theme'),
                'search_items' => __('Search Categories', 'ct_theme'),
                'popular_items' => __('Popular Categories', 'ct_theme'),
                'all_items' => __('All Categories', 'ct_theme'),
                'parent_item' => null,
                'parent_item_colon' => null,
                'edit_item' => __('Edit Meal Plan Category', 'ct_theme'),
                'update_item' => __('Update Meal Plan Category', 'ct_theme'),
                'add_new_item' => __('Add New Meal Plan Category', 'ct_theme'),
                'new_item_name' => __('New Meal Plan Category Name', 'ct_theme'),
                'separate_items_with_commas' => __('Separate Meal Plan category with commas', 'ct_theme'),
                'add_or_remove_items' => __('Add or remove Meal Plan category', 'ct_theme'),
                'choose_from_most_used' => __('Choose from the most used Meal Plan category', 'ct_theme'),
                'menu_name' => __('Categories', 'ct_theme'),
            ),
            'public' => false,
            'show_in_nav_menus' => false,
            'show_ui' => true,
            'show_tagcloud' => false,
            'query_var' => 'ctMealPlan_category',
            'rewrite' => false,

        ));
        register_taxonomy('ctMealPlan_category', 'ctMealPlan', $data);
        $this->callHook('post_register_taxonomies');

    }


    /**
     * Gets display method for meal plan
     * @param array $meta - post meta
     * @return null|string
     */
    public static function getMethodFromMeta($meta)
    {
        $method = isset($meta['display_method']) ? $meta['display_method'][0] : null;
        return $method;
    }

    /**
     * Handles rebuild
     */

    public function handleSlugOptionSaved($newValues)
    {
        $currentSlug = $this->getPermalinkSlug();
        //rebuild rewrite if new slug
        if (isset($newValues[self::OPTION_SLUG]) && ($currentSlug != $newValues[self::OPTION_SLUG])) {
            $this->callHook('pre_slug_option_saved', array('current_slug' => $currentSlug, 'new_slug' => $newValues[self::OPTION_SLUG]));

            //clean rewrite to refresh it
            delete_option('rewrite_rules');
        }
    }


    /**
     * Draw s menu meta
     */

    public function ctMealPlanEditMeta()
    {
        global $post;
        //new ctFoodPlan();
        $custom = get_post_custom($post->ID);
        $menuTableJson = isset($custom["menuTableJson"][0]) ? ctMealPlan::mergeMealtimes($custom["menuTableJson"][0]) : ctMealPlan::getInitJson();
        //var_dump(json_decode($custom["menuTableJson"][0]));
        //$menuTableJson =  ctWeeklyMenu::getInitJson(); //reset items
        ?>


        <form method="post" action="output.php">
            <textarea id="menuTableJson" style="display:none" name="menuTableJson" ><?php echo $menuTableJson //no escape required?></textarea>
        </form>


    <?php
    }



    /**
     * ctMealPlan template settings
     */

    public function ctMealPlanTemplateMeta()
    {
        global $post;
        $custom = get_post_custom($post->ID);

    }


    public function saveDetails()
    {
        global $post;

        $fields = array('menuTableJson'
        );

        foreach ($fields as $field) {
            if (isset($_POST[$field])) {
                update_post_meta($post->ID, $field, $_POST[$field]);
            }
        }
    }
}

new ctMealPlanType();