<?php
require_once CT_THEME_LIB_DIR . '/types/ctTypeBase.class.php';


/**
 * Custom type - Menu
 */
class ctMenuType extends ctTypeBase
{


    /**
     * Slug option name
     */

    const OPTION_SLUG = 'menu_index_slug';

    /**
     * Initializes menu
     * @return mixed|void
     */

    public function init()
    {
        add_action('template_redirect', array($this, 'menuContextFixer'));

        $this->registerType();
        //$this->registerTaxonomies();

        add_action("admin_init", array($this, "addMetaBox"));

        /** @var $NHP_Options NHP_Options */
        global $NHP_Options;
        //add options listener for license
        add_action('nhp-opts-options-validate-' . $NHP_Options->args['opt_name'], array($this, 'handleSlugOptionSaved'));
    }

    /**
     * Adds meta box
     */

    public function addMetaBox()
    {
        //add_meta_box("menu-meta", __("Menu settings", 'ct_theme'), array($this, "menuMeta"), "menu", "normal", "high");
        //add_action('save_post', array($this, 'saveDetails'));
    }

    /**
     * Fixes proper menu state
     */

    public function menuContextFixer()
    {
        if (get_query_var('post_type') == 'menu') {
            global $wp_query;
            $wp_query->is_home = false;
        }
        if (get_query_var('taxonomy') == 'menu_category') {
            global $wp_query;
            $wp_query->is_404 = true;
            $wp_query->is_tax = false;
            $wp_query->is_archive = false;
        }
    }

    /**
     * Register type
     */

    protected function registerType()
    {
        $typeData = $this->callFilter('pre_register_type', array(
            'labels' => array(
                'name' => _x('Menu', 'post type general name', 'ct_theme'),
                'singular_name' => _x('Menu item', 'post type singular name', 'ct_theme'),
                'add_new' => _x('Add New', 'menu item', 'ct_theme'),
                'add_new_item' => __('Add new Menu Item', 'ct_theme'),
                'edit_item' => __('Edit Menu Item', 'ct_theme'),
                'new_item' => __('New Menu Item', 'ct_theme'),
                'view_item' => __('View Menu Item', 'ct_theme'),
                'search_items' => __('Search Menu', 'ct_theme'),
                'not_found' => __('No Menu items found', 'ct_theme'),
                'not_found_in_trash' => __('No Menu found in Trash', 'ct_theme'),
                'parent_item_colon' => '',
                'menu_name' => __('Menu', 'ct_theme'),
            ),
            'singular_label' => __('Menu', 'ct_theme'),
            'public' => true,
            'publicly_queryable' => true,
            'exclude_from_search' => false,
            'show_ui' => true,
            'show_in_menu' => true,
            //'menu_position' => 20,
            'menu_icon' => 'dashicons-clipboard',
            'capability_type' => 'post',
            'hierarchical' => false,
            'supports' => array('title', 'editor', 'thumbnail', 'page-attributes'),
            'has_archive' => false,
            'rewrite' => array('slug' => $this->getPermalinkSlug(), 'with_front' => true, 'pages' => true, 'feeds' => false),
            'query_var' => false,
            'can_export' => true,
            'show_in_nav_menus' => true,
            'taxonomies' => array('post_tag')
        ));

        register_post_type('menu', $typeData);
        $this->callHook('post_register_type');
    }

    /**
     * Returns permalink slug
     * @return string
     */

    protected function getPermalinkSlug()
    {
        // Rewriting Permalink Slug
        $permalink_slug = ct_get_option('program', 'program');
        if (empty($permalink_slug)) {
            $permalink_slug = 'program';
        }

        return $permalink_slug;
    }

    /**
     * Gets hook name
     * @return string
     */
    protected function getHookBaseName()
    {
        return 'ct_program';
    }




    /**
     * Gets display method for menu
     * @param array $meta - post meta
     * @return null|string
     */
    public static function getMethodFromMeta($meta)
    {
        $method = isset($meta['display_method']) ? $meta['display_method'][0] : null;
        /*
        if (!$method) {
            $method = isset($meta['video'][0]) && trim($meta['video'][0]) ? 'video' : 'image';
        }
        */
        return $method;
    }

    /**
     * Handles rebuild
     */

    public function handleSlugOptionSaved($newValues)
    {
        $currentSlug = $this->getPermalinkSlug();
        //rebuild rewrite if new slug
        if (isset($newValues[self::OPTION_SLUG]) && ($currentSlug != $newValues[self::OPTION_SLUG])) {
            $this->callHook('pre_slug_option_saved', array('current_slug' => $currentSlug, 'new_slug' => $newValues[self::OPTION_SLUG]));

            //clean rewrite to refresh it
            delete_option('rewrite_rules');
        }
    }





    /**
     * menu template settings
     */

    public function menuTemplateMeta()
    {
        global $post;
        $custom = get_post_custom($post->ID);

    }


    public function saveDetails()
    {
        global $post;

        $fields = array(


        );
        foreach ($fields as $field) {
            if (isset($_POST[$field])) {
                update_post_meta($post->ID, $field, $_POST[$field]);
            }
        }
    }
}

new ctMenuType();