<?php
require_once CT_THEME_LIB_DIR . '/types/ctPageTypeBase.class.php';

/**
 * page type
 */
class ctPageType extends ctPageTypeBase
{

    /**
     * Adds meta box
     */

    public function addMetaBox()
    {
        parent::addMetaBox();
        add_meta_box("page-template-meta", __("Template settings", 'ct_theme'), array($this, "pageTemplateMeta"), "page", "normal", "high");
    }




    /**
     * page template settings
     */

    public function pageTemplateMeta()
    {
        global $post;
        $custom = get_post_custom($post->ID);
        $title = isset($custom["show_title"][0]) ? $custom["show_title"][0] : "";
        $bread = isset($custom["show_breadcrumbs"][0]) ? $custom["show_breadcrumbs"][0] : "";
        $header_block = isset($custom["header_block"][0]) ? $custom["header_block"][0] : "none";

        $page_meta_top_img = isset($custom["page_meta_top_img"][0]) ? $custom["page_meta_top_img"][0] : "";
        $page_meta_top_img_top = isset($custom["page_meta_top_img_top"][0]) ? $custom["page_meta_top_img_top"][0] : "";
        $page_meta_top_img_left = isset($custom["page_meta_top_img_left"][0]) ? $custom["page_meta_top_img_left"][0] : "0";
        $show_page_obj = isset($custom["show_page_obj"][0]) ? $custom["show_page_obj"][0] : "global";
        ?>

        <p>
            <label for="show_title"><?php _e('Show title', 'ct_theme') ?>: </label>
            <select id="show_title" name="show_title">
                <option
                    value="global" <?php echo selected('global', $title) ?>><?php _e("use global settings", 'ct_theme') ?></option>
                <option value="yes" <?php echo selected('yes', $title) ?>><?php _e("show title", 'ct_theme') ?></option>
                <option value="no" <?php echo selected('no', $title) ?>><?php _e("hide title", 'ct_theme') ?></option>
            </select>
        </p>
        <p class="howto"><?php _e("Show page title?", 'ct_theme') ?></p>

        <p>
            <label for="show_breadcrumbs"><?php _e('Show breadcrumbs', 'ct_theme') ?>: </label>
            <select id="show_breadcrumbs" name="show_breadcrumbs">
                <option
                    value="global" <?php echo selected('global', $bread) ?>><?php _e("use global settings", 'ct_theme') ?></option>
                <option
                    value="yes" <?php echo selected('yes', $bread) ?>><?php _e("show breadcrumbs", 'ct_theme') ?></option>
                <option
                    value="no" <?php echo selected('no', $bread) ?>><?php _e("hide breadcrumbs", 'ct_theme') ?></option>
            </select>
        </p>
        <p class="howto"><?php _e("Show breadcrumbs?", 'ct_theme') ?></p>



        <?php
         $attributes['limit'] = 1000;
        $recentposts = get_posts(array('post_type' => 'ct_header_block'), $attributes);

        if (is_array($recentposts) && !empty($recentposts)):?>
             <p>
                <label for="header_block"><?php _e('select block header', 'ct_theme') ?>: </label>
                <select id="header_block" name="header_block">
                    <option value="" <?php echo selected('none', $header_block) ?>></option>
                <?php


            foreach ($recentposts as $p):;?>
                <option
                    value="<?php echo esc_html($p->ID) ?>" <?php echo selected($p->ID, $header_block) ?>><?php echo esc_html($p->post_title) ?></option>
            <?php
            endforeach;
            ?>
                </select>
            </p>
        <?php endif?>


        <br><hr>
        <label for="show_page_obj"><?php _e('Show top page object', 'ct_theme') ?>: </label>
        <select id="show_page_obj" name="show_page_obj">
            <option
                value="global" <?php echo selected('global', $show_page_obj) ?>><?php _e("use global settings", 'ct_theme') ?></option>
            <option
                value="yes" <?php echo selected('yes', $show_page_obj) ?>><?php _e("show top page object", 'ct_theme') ?></option>
            <option
                value="no" <?php echo selected('no', $show_page_obj) ?>><?php _e("hide top page object", 'ct_theme') ?></option>
        </select>
        </p>
        <p class="howto"><?php _e("Show top page object?", 'ct_theme') ?></p>


        <p>
            <label for="page_meta_top_img"><?php _e('Top img url', 'ct_theme') ?></label>
            <input type="text" id="page_meta_top_img" class="regular-text" name="page_meta_top_img"
                   value="<?php echo esc_url($page_meta_top_img); ?>"/>
        <p class="howto"><?php _e("Top img url", 'ct_theme') ?></p>


        <p>
            <label for="page_meta_top_img_top"><?php _e('Top margin', 'ct_theme') ?></label>
            <input type="text" id="page_meta_top_img_top" class="regular-text" name="page_meta_top_img_top"
                   value="<?php echo esc_html($page_meta_top_img_top); ?>"/>
        <p class="howto"><?php _e("Top img", 'ct_theme') ?></p>


        <p>
            <label for="page_meta_top_img_left"><?php _e('Left margin', 'ct_theme') ?></label>
            <input type="text" id="page_meta_top_img_left" class="regular-text" name="page_meta_top_img_left"
                   value="<?php echo esc_html($page_meta_top_img_left); ?>"/>
        <p class="howto"><?php _e("Left img", 'ct_theme') ?></p>



	<?php
    }


    public function saveDetails()
    {
        parent::saveDetails();
        global $post;

        $fields = array('show_title', 'show_breadcrumbs', 'header_block', 'page_meta_top_img', 'show_page_obj', 'page_meta_top_img_left', 'page_meta_top_img_top');
        foreach ($fields as $field) {
            if (isset($_POST[$field])) {
                update_post_meta($post->ID, $field, $_POST[$field]);
            }
        }
    }
}

new ctPageType();