<?php
require_once CT_THEME_LIB_DIR . '/types/ctTypeBase.class.php';


/**
 * Custom type - Program
 */
class ctProgramType extends ctTypeBase
{


    /**
     * Slug option name
     */

    const OPTION_SLUG = 'program_index_slug';

    /**
     * Initializes program
     * @return mixed|void
     */

    public function init()
    {
        add_action('template_redirect', array($this, 'programContextFixer'));

        $this->registerType();
        $this->registerTaxonomies();

        add_action("admin_init", array($this, "addMetaBox"));

        /** @var $NHP_Options NHP_Options */
        global $NHP_Options;
        //add options listener for license
        add_action('nhp-opts-options-validate-' . $NHP_Options->args['opt_name'], array($this, 'handleSlugOptionSaved'));
    }

    /**
     * Adds meta box
     */

    public function addMetaBox()
    {
        add_meta_box("program-meta", __("Program settings", 'ct_theme'), array($this, "programMeta"), "program", "normal", "high");
        add_meta_box("social-meta", __("Socials settings", 'ct_theme'), array($this, "socialsMeta"), "program", "normal", "high");


        add_action('save_post', array($this, 'saveDetails'));
    }

    /**
     * Fixes proper menu state
     */

    public function programContextFixer()
    {
        if (get_query_var('post_type') == 'program') {
            global $wp_query;
            $wp_query->is_home = false;
        }
        if (get_query_var('taxonomy') == 'program_category') {
            global $wp_query;
            $wp_query->is_404 = true;
            $wp_query->is_tax = false;
            $wp_query->is_archive = false;
        }
    }

    /**
     * Register type
     */

    protected function registerType()
    {
        $typeData = $this->callFilter('pre_register_type', array(
            'labels' => array(
                'name' => _x('Program', 'post type general name', 'ct_theme'),
                'singular_name' => _x('Program item', 'post type singular name', 'ct_theme'),
                'add_new' => _x('Add New', 'program', 'ct_theme'),
                'add_new_item' => __('Add New Program Item', 'ct_theme'),
                'edit_item' => __('Edit Program Item', 'ct_theme'),
                'new_item' => __('New Program Item', 'ct_theme'),
                'view_item' => __('View Program Item', 'ct_theme'),
                'search_items' => __('Search Programs', 'ct_theme'),
                'not_found' => __('No Programs found', 'ct_theme'),
                'not_found_in_trash' => __('No Program found in Trash', 'ct_theme'),
                'parent_item_colon' => '',
                'menu_name' => __('Programs', 'ct_theme'),
            ),
            'singular_label' => __('Program', 'ct_theme'),
            'public' => true,
            'publicly_queryable' => true,
            'exclude_from_search' => false,
            'show_ui' => true,
            'show_in_menu' => true,
            //'menu_position' => 20,
            'menu_icon' => 'dashicons-exerpt-view',
            'capability_type' => 'post',
            'hierarchical' => false,
            'supports' => array('title', 'editor', 'thumbnail', 'page-attributes'),
            'has_archive' => false,
            'rewrite' => array('slug' => $this->getPermalinkSlug(), 'with_front' => true, 'pages' => true, 'feeds' => false),
            'query_var' => false,
            'can_export' => true,
            'show_in_nav_menus' => true,
            'taxonomies' => array('post_tag')
        ));

        register_post_type('program', $typeData);
        $this->callHook('post_register_type');
    }

    /**
     * Returns permalink slug
     * @return string
     */

    protected function getPermalinkSlug()
    {
        // Rewriting Permalink Slug
        $permalink_slug = ct_get_option('program', 'program');
        if (empty($permalink_slug)) {
            $permalink_slug = 'program';
        }

        return $permalink_slug;
    }

    /**
     * Gets hook name
     * @return string
     */
    protected function getHookBaseName()
    {
        return 'ct_program';
    }

    /**
     * Creates taxonomies
     */

    protected function registerTaxonomies()
    {
        $data = $this->callFilter('pre_register_taxonomies', array(
            'hierarchical' => true,
            'labels' => array(
                'name' => _x('Program Categories', 'taxonomy general name', 'ct_theme'),
                'singular_name' => _x('Program Category', 'taxonomy singular name', 'ct_theme'),
                'search_items' => __('Search Categories', 'ct_theme'),
                'popular_items' => __('Popular Categories', 'ct_theme'),
                'all_items' => __('All Categories', 'ct_theme'),
                'parent_item' => null,
                'parent_item_colon' => null,
                'edit_item' => __('Edit Program Category', 'ct_theme'),
                'update_item' => __('Update Program Category', 'ct_theme'),
                'add_new_item' => __('Add New Program Category', 'ct_theme'),
                'new_item_name' => __('New Program Category Name', 'ct_theme'),
                'separate_items_with_commas' => __('Separate Program category with commas', 'ct_theme'),
                'add_or_remove_items' => __('Add or remove Program category', 'ct_theme'),
                'choose_from_most_used' => __('Choose from the most used Program category', 'ct_theme'),
                'menu_name' => __('Categories', 'ct_theme'),
            ),
            'public' => false,
            'show_in_nav_menus' => false,
            'show_ui' => true,
            'show_tagcloud' => false,
            'query_var' => 'program_category',
            'rewrite' => false,

        ));
        register_taxonomy('program_category', 'program', $data);
        $this->callHook('post_register_taxonomies');
    }


    /**
     * Gets display method for program
     * @param array $meta - post meta
     * @return null|string
     */
    public static function getMethodFromMeta($meta)
    {
        $method = isset($meta['display_method']) ? $meta['display_method'][0] : null;
        /*
        if (!$method) {
            $method = isset($meta['video'][0]) && trim($meta['video'][0]) ? 'video' : 'image';
        }
        */
        return $method;
    }

    /**
     * Handles rebuild
     */

    public function handleSlugOptionSaved($newValues)
    {
        $currentSlug = $this->getPermalinkSlug();
        //rebuild rewrite if new slug
        if (isset($newValues[self::OPTION_SLUG]) && ($currentSlug != $newValues[self::OPTION_SLUG])) {
            $this->callHook('pre_slug_option_saved', array('current_slug' => $currentSlug, 'new_slug' => $newValues[self::OPTION_SLUG]));

            //clean rewrite to refresh it
            delete_option('rewrite_rules');
        }
    }


    /**
     * Draw s program meta
     */

    public function programMeta()
    {
        global $post;
        $custom = get_post_custom($post->ID);




        $program_meta_age_min = isset($custom["program_meta_age_min"][0]) ? $custom["program_meta_age_min"][0] : "1";
        $program_meta_age_max = isset($custom["program_meta_age_max"][0]) ? $custom["program_meta_age_max"][0] : "1";
        $summary = isset($custom["summary"][0]) ? $custom["summary"][0] : "";

        $program_meta_top_img = isset($custom["program_meta_top_img"][0]) ? $custom["program_meta_top_img"][0] : "";
        $program_meta_top_img_top = isset($custom["program_meta_top_img_top"][0]) ? $custom["program_meta_top_img_top"][0] : "";
        $program_meta_top_img_left = isset($custom["program_meta_top_img_left"][0]) ? $custom["program_meta_top_img_left"][0] : "0";
        ?>


        <p>
            <label for="summary"><?php _e('Summary', 'ct_theme') ?></label>
            <textarea id="summary" class="regular-text" name="summary" cols="100"
                      rows="5"><?php echo esc_html($summary); ?></textarea>
        <p class="howto"><?php _e("Summary will be show on index page", 'ct_theme') ?></p>


        <p>
            <label for="program_meta_age_min"><?php _e('From year', 'ct_theme')?></label>
            <input type="text" id="program_meta_age_min" class="regular-text" name="program_meta_age_min"
                   value="<?php echo esc_html($program_meta_age_min); ?>"/>
        <p class="howto"><?php _e("Minimum age", 'ct_theme') ?></p>

        <p>
            <label for="program_meta_age_max"><?php _e('To years', 'ct_theme')?></label>
            <input type="text" id="program_meta_age_max" class="regular-text" name="program_meta_age_max"
                   value="<?php echo esc_html($program_meta_age_max); ?>"/>
        <p class="howto"><?php _e("Max age", 'ct_theme') ?></p>


        <p>
            <label for="program_meta_top_img"><?php _e('Top img url', 'ct_theme')?></label>
            <input type="text" id="program_meta_top_img" class="regular-text" name="program_meta_top_img"
                   value="<?php echo esc_url($program_meta_top_img); ?>"/>
        <p class="howto"><?php _e("Top img url", 'ct_theme') ?></p>


        <p>
            <label for="program_meta_top_img_top"><?php _e('Top img top margin', 'ct_theme')?></label>
            <input type="text" id="program_meta_top_img_top" class="regular-text" name="program_meta_top_img_top"
                   value="<?php echo (int)$program_meta_top_img_top; ?>"/>
        <p class="howto"><?php _e("Top img", 'ct_theme') ?></p>


        <p>
            <label for="program_meta_top_img_left"><?php _e('Top img left margin', 'ct_theme')?></label>
            <input type="text" id="program_meta_top_img_left" class="regular-text" name="program_meta_top_img_left"
                   value="<?php echo (int)$program_meta_top_img_top; ?>"/>
        <p class="howto"><?php _e("Left img", 'ct_theme') ?></p>

    <?php
    }

    public function socialsMeta()
    {
        global $post;
        $custom = get_post_custom($post->ID);
        $socials = new ctSocialsMetaFields();
        $socials->theFields($custom);
    }


    /**
     * program template settings
     */

    public function programTemplateMeta()
    {
        global $post;
        $custom = get_post_custom($post->ID);

    }


    public function saveDetails()
    {
        global $post;

        $fields = array(
            'program_meta_age_min',
            'program_meta_age_max',
            'program_meta_top_img',
            'program_meta_top_img_top',
            'program_meta_top_img_left'
        );
        $fields = array_merge(ctSocialsMetaFields::getFieldsArray(), $fields);

        foreach ($fields as $field) {
            if (isset($_POST[$field])) {
                update_post_meta($post->ID, $field, $_POST[$field]);
            }
        }
    }
}

new ctProgramType();