<?php get_template_part('templates/page', 'head'); ?>
<?php $breadcrumbs = ct_show_single_post_breadcrumbs('page') ? 'yes' : 'no'; ?>

<?php if (is_shop()) {
    $pageTitle = woocommerce_page_title(false);
} elseif (is_product_category()) {
    $pageTitle = woocommerce_page_title(false);
} elseif (is_product_tag()) {
    $pageTitle = woocommerce_page_title(false);
} else {
    $pageTitle = ct_get_single_post_title('page');
} ?>


</div><!--container end!-->


<?php $custom = get_post_custom(get_the_ID()) ?>
<?php if (isset($custom['above_content'][0]) && $custom['above_content'][0] != '') {
    echo do_shortcode(($custom['above_content'][0]));
} ?>


<?php
$show = false;
$image = '';
$top = 0;
$left = 0;

if (!isset($custom['show_page_obj'][0])) {
    $custom['show_page_obj'][0] = 'gl   obal';
}
if (ct_get_option('effects_top_object_show', 1)) {
    if (isset($custom['show_page_obj'][0]) && $custom['show_page_obj'][0] == 'yes') {
        if (isset($custom['page_meta_top_img'][0]) && isset ($custom['page_meta_top_img_top'][0]) && isset ($custom['page_meta_top_img_left'][0])) {
            $image = $custom['page_meta_top_img'][0];
            $top = $custom['page_meta_top_img_top'][0];
            $left = $custom['page_meta_top_img_left'][0];
            $show = true;
        }
    } else if ($custom['show_page_obj'][0] == 'global') {
        if (ct_get_option('effects_top_object_image') != '') {
            $image = ct_get_option('effects_top_object_image', '');
            $top = ct_get_option('effects_top_object_top', 0);
            $left = ct_get_option('effects_top_object_left', 0);
            $show = true;
        }
    } else {
        $show = false;
        //var_dump($show);
    }

} else {
    $show = false;
}

$basketTotal = $woocommerce->cart->get_cart_total();
$basketCounter = sprintf(_n('%d item', '%d items', $woocommerce->cart->cart_contents_count, 'ct_theme'), $woocommerce->cart->cart_contents_count);
?>


<div class="container">
    <div class="row below-menu">
        <div class="col-md-9">
            <div class="shadow-box">
                <?php if ($show == true): ?>

                    <div class="pageobject"<?php echo ct_esc_attrs(array(
                            array('attr' => 'data-left', 'val' => $left . 'px'),
                            array('attr' => 'data-top', 'val' => $top),
                            array('attr' => 'data-zindex', 'val' => '1000'))
                    )?>>
                        <img src="<?php echo esc_url($image) ?>" alt="<?php echo __('top image', 'ct_theme') ?>">
                    </div>

                <?php endif ?>

                <?php if ($pageTitle || $breadcrumbs == "yes"): ?>
                    <div class="row ct-page-title">
                        <div class="col-sm-6">
                            <?php

                            if (!is_product()):
                                ?>
                                <h4 class="color-motive uppercase"><?php echo esc_html($pageTitle) ?></h4>
                            <?php
                            elseif (is_product()):
                                ?>
                                <h4 class="color-motive uppercase">Shop</h4>
                            <?php
                            endif;
                            ?>

                        </div>
                        <div class="col-sm-6">
                            <?php

                            if (!is_product()):
                                do_action('ct_product_list_number');
                            elseif (is_product()):
                                do_action('ct_custom_breadcrumb');
                            endif;
                            ?>
                        </div>
                    </div>

                    <hr>


                <?php endif ?>

                <?php woocommerce_content(); ?>

                <?php if (is_product()): ?>
                    <section class="section-bottom">
                        <div class="container">
                            <!-- custom related products -->
                        </div>
                    </section>
                <?php endif; ?>
            </div>
        </div>
        <div class="col-md-3 sidebar">
            <div class="row">


                <div class="clearfix"></div>
                <?php
                if (!is_product()):
                    ?>
                    <?php
                    get_template_part('templates/sidebar-woocommerce')
                    ?>
                <?php endif; ?>
                <?php
                if (is_product()):
                    ?>
                    <div class="col-sm-6 col-md-12">
                        <div class="shadow-box daycare-widget">
                            <?php
                            do_action('ct_before_sidebar_product');
                            ?>
                        </div>
                    </div>
                    <div class="col-sm-6 col-md-12 visible-md visible-lg">
                        <div class="shadow-box daycare-widget">
                            <?php do_action('woocommerce_product_thumbnails'); ?>
                        </div>
                    </div>

                    <?php if (ct_get_option('shop_product_single_show_share',1)):?>
                    <div class="col-sm-6 col-md-12">
                        <div class="shadow-box daycare-widget">
                            <?php

                            do_action('ct_product_share');

                            ?>
                        </div>
                    </div>
                    <?php endif ?>


                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

