<?php
/**
 * Checkout Form
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.3.0
 */

if (!defined('ABSPATH')) exit; // Exit if accessed directly

global $woocommerce;

wc_print_notices();

do_action('woocommerce_before_checkout_form', $checkout);

// If checkout registration is disabled and not logged in, the user cannot checkout
if (!$checkout->enable_signup && !$checkout->enable_guest_checkout && !is_user_logged_in()) {
    echo esc_html(apply_filters('woocommerce_checkout_must_be_logged_in_message', __('You must be logged in to checkout.', 'woocommerce')));
    return;
}

// filter hook for include new pages inside the payment method
$get_checkout_url = apply_filters('woocommerce_get_checkout_url', WC()->cart->get_checkout_url()); ?>

    <form name="checkout" method="post" class="checkout" action="<?php echo esc_url($get_checkout_url); ?>">

        <?php if (sizeof($checkout->checkout_fields) > 0) { ?>

            <?php do_action('woocommerce_checkout_before_customer_details'); ?>

            <div class="row" id="customer_details">

                <div class="col-md-8">

                    <?php do_action('woocommerce_checkout_billing'); ?>
                    <?php do_action('woocommerce_checkout_shipping'); ?>

                </div>

                <div class="col-md-4">

                    <h4 id="order_review_heading"
                        class="color-motive uppercase"><?php _e('Your order', 'ct_theme'); ?></h4>

                    <?php do_action('woocommerce_checkout_order_review'); ?>

                </div>

            </div>

            <?php do_action('woocommerce_checkout_after_customer_details'); ?>

        <?php } else { ?>

            <h4 id="order_review_heading" class="color-motive uppercase"><?php _e('Your order', 'ct_theme'); ?></h4>

            <?php do_action('woocommerce_checkout_order_review'); ?>

        <?php } ?>

    </form>

<?php do_action('woocommerce_after_checkout_form', $checkout); ?>