<?php
#####################################################################################
# ADD SOME FILTERS...                                                               #
#####################################################################################

// Q&D: handles 404 statuses (generated by WP) to allow them to be successfully handled by Ext.Ajax
function status_header_fixed( $header ) {
    if (strstr($header,'404')) {
        return 'HTTP/1.1 200 OK';
    }
    return $header;
}
add_filter('status_header', 'status_header_fixed');

// Q&D: add rel to attachements links
function make_noajax($url = '') {
     return $url.'\' rel=\'noajax';
}
add_filter('wp_get_attachment_url', 'make_noajax');


#####################################################################################
# REWRITE FEW WIDGETS...                                                            #
#####################################################################################
if ( function_exists('register_sidebar') ) {
	register_sidebar(array(
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div></div>',
        'before_title' => '<div class="wtitle">',
        'after_title' => '&#160;</div><div class="text-content">',
    ));
}
// calendar
require_once('widget_calendar.php');
if ( function_exists('register_sidebar_widget') ) {
    register_sidebar_widget(__('Calendar'), 'widget_extjslike_calendar');
}
// search
require_once('widget_search.php');
if ( function_exists('register_sidebar_widget') ) {
    register_sidebar_widget(__('Search'), 'widget_extjslike_search');
}


#####################################################################################
# BREAKS TEMPLATE HIERARCHY                                                         #
#####################################################################################

function json_data () {
    include(TEMPLATEPATH . '/json_data.php');
    exit;
}
function content_widget_calendar() {
    include(TEMPLATEPATH . '/content_widget_calendar.php');
    exit;
}
function content_posts () {
    include(TEMPLATEPATH . '/content_posts.php');
    exit;
}
function content_recent_comments () {
    include(TEMPLATEPATH . '/content_recent_comments.php');
    exit;
}
function comments_ajax () {
    include(TEMPLATEPATH . '/comments_ajax.php');
    exit;
}

if (isset($_GET['jsonData'])) {
    add_action('template_redirect', 'json_data');
}
if (isset($_POST['backgroundCalendar'])) {
    add_action('template_redirect', 'content_widget_calendar');
}
if (isset($_POST['backgroundPosts'])) {
    add_action('template_redirect', 'content_posts');
}
if (isset($_GET['backgroundRecentComments'])) {
    add_action('template_redirect', 'content_recent_comments');
}
if (isset($_GET['comments_ajax'])) {
    add_action('template_redirect', 'comments_ajax');
}


function sitemap () {
    include(TEMPLATEPATH . '/sitemap.php');
    exit;
}
if (isset($_GET['sitemap'])) {
    add_action('template_redirect', 'sitemap');
}
?>
