<?php
/**
 * The default template for displaying content
 *
 * @package WordPress
 * @subpackage pulp
 * @since pulp 1.0
 */
?>

<div id="post-<?php the_ID(); ?>" <?php post_class('blog'); ?>>

    <div class="fancy_border">
        <div class="blog_date">
            <span class="day"><?php echo get_the_date('jS');?></span>
            <span class="month"><?php echo get_the_date('M');?></span>
            <span class="year"><?php echo get_the_date('Y');?></span>
        </div>
        <?php if ( has_post_thumbnail() ) { ?>
            <div class="blog_image">
                <a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'pulp' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark">
                    <?php
                    if ( has_post_thumbnail() ) {
                        the_post_thumbnail( );
                    }
                    ?>
                </a>
            </div>
        <?php } ?>
        <div class="blog_header">
            <h2 class="entry-title <?php echo ( is_sticky() ) ? ' featured-post' : '';?> ?>"><span><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'pulp' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a></span></h2>
        </div>
        <div class="blog_summary">
            <?php the_excerpt(); ?>
            <?php /* <?php else : ?>
            <div class="entry-content">
                <?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'pulp' ) ); ?>
                <?php wp_link_pages( array( 'before' => '<div class="page-link"><span>' . __( 'Pages:', 'pulp' ) . '</span>', 'after' => '</div>' ) ); ?>
            </div><!-- .entry-content3 -->
            <?php endif; ?>
*/ ?>
        </div>
        <?php if ( 'post' == get_post_type() ) : ?>
        <div class="blog_footer">
            <ul>
                <li>
                    <a href="<?php the_permalink();?>"><?php _e('Read More','pulp');?></a>
                </li>
                <!-- <li>
                    <?php pulp_posted_on() ;?>
                </li>
                <?php if ( comments_open() ) : ?>
                <li>
                    <?php comments_popup_link( '<span class="leave-comment">' . __( 'Leave a comment', 'pulp' ) . '</span>', __( '<b>1</b> Comment', 'pulp' ), __( '<b>%</b> Comments', 'pulp' ) ); ?>
                </li>
                <?php endif; // End if comments_open() ?> -->
                <?php
                /* translators: used between list items, there is a space after the comma */
                $categories_list = get_the_category_list( __( ', ', 'pulp' ) );
                if ( $categories_list ):
                    ?>
                    <li>
                        <?php printf( __( '<span class="%1$s">Categories:</span> %2$s', 'pulp' ), 'entry-utility-prep entry-utility-prep-cat-links', $categories_list ); ?>
                    </li>
                    <?php endif; // End if categories ?>
                <?php
                /* translators: used between list items, there is a space after the comma */
                $tags_list = get_the_tag_list( '', __( ', ', 'pulp' ) );
                if ( $tags_list ):
                    ?>
                    <li>
                        <?php printf( __( '<span class="%1$s">Tags:</span> %2$s', 'pulp' ), 'entry-utility-prep entry-utility-prep-tag-links', $tags_list ); ?>
                    </li>
                    <?php endif; // End if $tags_list ?>
                <?php edit_post_link( __( 'Edit', 'pulp' ), '<li class="edit-link">', '</li>' ); ?>
            </ul>
            <div class="clear"></div>
        </div>

        <?php endif; ?>
    </div>


</div><!-- #post-<?php the_ID(); ?> -->










