<?php

class Custom_Gallery_Setting {
    /**
     * Stores the class instance.
     *
     * @var Custom_Gallery_Setting
     */
    private static $instance = null;


    /**
     * Returns the instance of this class.
     *
     * It's a singleton class.
     *
     * @return Custom_Gallery_Setting The instance
     */
    public static function get_instance() {

        if ( ! self::$instance )
            self::$instance = new self;

        return self::$instance;
    }

    /**
     * Initialises the plugin.
     */
    public function init_plugin() {

        $this->init_hooks();
    }

    /**
     * Initialises the WP actions.
     *  - admin_print_scripts
     */
    private function init_hooks() {

        add_action( 'wp_enqueue_media', array( $this, 'wp_enqueue_media' ) );
        add_action( 'print_media_templates', array( $this, 'print_media_templates' ) );
    }


    /**
     * Enqueues the script.
     */
    public function wp_enqueue_media() {

        if ( ! isset( get_current_screen()->id ) || get_current_screen()->base != 'post' )
            return;

        wp_enqueue_script(
            'custom-gallery-settings',
            get_template_directory_uri(). '/js/custom-gallery-setting.js',
            array( 'media-views' )
        );

    }

    /**
     * Outputs the view template with the custom setting.
     */
    public function print_media_templates() {

        if ( ! isset( get_current_screen()->id ) || get_current_screen()->base != 'post' )
            return;

        ?>

        <script type="text/html" id="tmpl-custom-gallery-setting">
            <label class="setting">
                <span>Image Size</span>
                <select class="type" name="size" data-setting="size">
                    <?php

                    $sizes = apply_filters( 'image_size_names_choose', array(
                        'gallery1' => __( 'Small Thumbnails' ),
                        'galleryslider'    => __( 'Large Images' ),
                        '0'    => __( 'Original Size' ),
                    ) );

                    foreach ( $sizes as $value => $name ) { ?>
                        <option value="<?php echo esc_attr( $value ); ?>" <?php selected( $value, 'thumbnail' ); ?>>
                            <?php echo esc_html( $name ); ?>
                        </option>
                    <?php } ?>
                </select>
            </label>
            <label class="setting">
                <span>Slider</span>
                <select class="type" name="slider" data-setting="slider">
                    <?php
                    $options = array(
                        'no' => 'No Image Slider',
                        'flexslider' => 'Yes Image Slider',
                    );
                    foreach ( $options as $value => $name ) { ?>
                        <option value="<?php echo esc_attr( $value ); ?>" <?php selected( $value, 'no' ); ?>>
                            <?php echo esc_html( $name ); ?>
                        </option>
                    <?php } ?>
                </select>
            </label>
        </script>
        <script type="text/javascript">
            ( function( $ ) {
                var media = wp.media;

                // Wrap the render() function to append controls
                media.view.Settings.Gallery = media.view.Settings.Gallery.extend({
                    render: function() {
                        media.view.Settings.prototype.render.apply( this, arguments );

                        // Append the custom template
                        this.$el.append( media.template( 'custom-gallery-setting' ) );

                        // Save the setting
                        media.gallery.defaults.size = 'thumbnail';
                        media.gallery.defaults.slider = 'no';
                        //media.gallery.defaults.link = 'file'; // not sure if this will go fucky or not.
                        this.update.apply( this, ['size'] );
                        this.update.apply( this, ['slider'] );
                        return this;
                    }
                } );
            } )( jQuery );
        </script>
        <?php
    }

}

// Put your hands up...
add_action( 'admin_init', array( Custom_Gallery_Setting::get_instance(), 'init_plugin' ), 20 );


add_action( 'after_setup_theme', 'dtbaker_pulp_gallery' );
function dtbaker_pulp_gallery(){
    add_image_size( 'gallery1', 171, 113, true);
    add_image_size( 'galleryslider', 570, 290, true);
}

add_filter('post_gallery', 'dtbaker_pulp_post_gallery', 10, 2);
function dtbaker_pulp_post_gallery($output, $attr){
    if($output != '')return $output;

    // copy of gallery output function from wp-includes/media.php
    // We're trusting author input, so let's at least make sure it looks like a valid orderby statement
	if ( isset( $attr['orderby'] ) ) {
		$attr['orderby'] = sanitize_sql_orderby( $attr['orderby'] );
		if ( !$attr['orderby'] )
			unset( $attr['orderby'] );
	}

	extract(shortcode_atts(array(
		'order'      => 'ASC',
		'orderby'    => 'menu_order ID',
		'id'         => $post->ID,
		'itemtag'    => 'dl',
		'icontag'    => 'dt',
		'captiontag' => 'dd',
		'columns'    => 3,
		'size'       => 'thumbnail',
		'include'    => '',
		'exclude'    => ''
	), $attr));

	$id = intval($id);
	if ( 'RAND' == $order )
		$orderby = 'none';

	if ( !empty($include) ) {
		$_attachments = get_posts( array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );

		$attachments = array();
		foreach ( $_attachments as $key => $val ) {
			$attachments[$val->ID] = $_attachments[$key];
		}
	} elseif ( !empty($exclude) ) {
		$attachments = get_children( array('post_parent' => $id, 'exclude' => $exclude, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
	} else {
		$attachments = get_children( array('post_parent' => $id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
	}

	if ( empty($attachments) )
		return '';

	if ( is_feed() ) {
		$output = "\n";
		foreach ( $attachments as $att_id => $attachment )
			$output .= wp_get_attachment_link($att_id, $size, true) . "\n";
		return $output;
	}


	$size_class = sanitize_html_class( $size );
	$selector = "gallery-{$instance}";



	if ( isset( $attr['slider'] ) ) {
        switch($attr['slider']){
            case 'flexslider':
                ob_start();
                ?>
<link rel="stylesheet" href="<?php echo get_template_directory_uri();?>/flexslider/flexslider.css" type="text/css">
<script src="<?php echo get_template_directory_uri();?>/flexslider/jquery.flexslider.js"></script>
<script type="text/javascript" charset="utf-8">
  jQuery(window).load(function() {
    jQuery('.flexslider').flexslider({
    });
  });
</script>

<div id="<?php echo $selector;?>" class="gallery galleryid-<?php echo $id;?> gallery-size-<?php echo $size_class;?> fancy_border">
    <div class="flexslider">
      <ul class="slides">
          <?php
        foreach ( $attachments as $id => $attachment ) {
            //$link = isset($attr['link']) && 'file' == $attr['link'] ? wp_get_attachment_link($id, $size, false, false) : wp_get_attachment_link($id, $size, true, false);

            $url = wp_get_attachment_image_src($attachment->ID, $size);
            $link_url = get_post_meta($attachment->ID, '_sliderlink', true);
            ?>
            <li>
                <?php if($link_url){ ?>
                    <a href="<?php echo $link_url;?>"><img src="<?php echo $url[0];?>" border="0" alt="" title=""></a>
                <?php }else{ ?>
                    <img src="<?php echo $url[0];?>" border="0" alt="<?php echo esc_attr($attachment->post_excerpt);?>" title="<?php echo esc_attr($attachment->post_excerpt);?>">
                <?php } ?>
                <?php if(trim($attachment->post_excerpt)){ ?>
                <p class="flex-caption"><?php echo wptexturize($attachment->post_excerpt);?></p>
                <?php } ?>
            </li>
        <?php } ?>
      </ul>
    </div>
</div>
                <?php

                return ob_get_clean();
        }

    }

	$itemtag = tag_escape($itemtag);
	$captiontag = tag_escape($captiontag);
	$icontag = tag_escape($icontag);
	$valid_tags = wp_kses_allowed_html( 'post' );
	if ( ! isset( $valid_tags[ $itemtag ] ) )
		$itemtag = 'dl';
	if ( ! isset( $valid_tags[ $captiontag ] ) )
		$captiontag = 'dd';
	if ( ! isset( $valid_tags[ $icontag ] ) )
		$icontag = 'dt';

	$columns = intval($columns);
	$itemwidth = $columns > 0 ? floor(100/$columns) : 100;
	$float = is_rtl() ? 'right' : 'left';


	$gallery_style = $gallery_div = '';

    $gallery_flexbox =  isset($attr['link']) && 'file' == $attr['link'] ? ' gallery-flexbox' : '';
	$gallery_div = "<div id='$selector' class='gallery galleryid-{$id} gallery-columns-{$columns} gallery-size-{$size_class}{$gallery_flexbox}'>";
	$output = apply_filters( 'gallery_style', $gallery_style . "\n\t\t" . $gallery_div );

	$i = 0;
	foreach ( $attachments as $id => $attachment ) {
		if(isset($attr['link']) && 'file' == $attr['link']){
            $link = '<a href="'.wp_get_attachment_url($id).'" title="'.esc_attr($attachment->post_excerpt).'">';
            $link .= wp_get_attachment_image($id, $size);
            $link .= '</a>';
            //wp_get_attachment_link($id, $size, false, false)
        }else{
            $link = wp_get_attachment_link($id, $size, true, false);
        }

		$output .= "<{$itemtag} class='gallery-item";
        $i++;
		if ( $columns > 0 && $i % $columns == 0 ){
            $output .= " gallery-item-last";
        }
        $output .= "'>";
		$output .= "
			<{$icontag} class='gallery-icon'>
				$link
			</{$icontag}>";
		if ( $captiontag && trim($attachment->post_excerpt) ) {
			$output .= "
				<{$captiontag} class='wp-caption-text gallery-caption'>
				" . wptexturize($attachment->post_excerpt) . "
				</{$captiontag}>";
		}
		$output .= "</{$itemtag}>";
		if ( $columns > 0 && $i % $columns == 0 ){
            $output .= " <br style='clear: both;' />";
        }
	}

	$output .= "
			<br style='clear: both;' />
		</div>\n";

	return $output;
}


/**
 * Adding our custom fields to the $form_fields array
 *
 * @param array $form_fields
 * @param object $post
 * @return array
 */
function dtbaker_pulp_image_attachment_fields_to_edit($form_fields, $post) {
    // we find out the post data.
    if(!$post||!$post->post_parent)return $form_fields;

    // add our custom field to the $form_fields array
    // input type="text" name/id="attachments[$attachment->ID][custom1]"
    $form_fields["sliderlink"] = array(
        "label" => __("Slider Link",'pulp'),
        "input" => "text", // this is default if "input" is omitted
        "value" => get_post_meta($post->ID, "_sliderlink", true),
        "helps" => __('(optional) Please enter the full URL where users will be directed after clicking on this gallery image.','pulp'),
    );

    return $form_fields;
}
// attach our function to the correct hook
add_filter("attachment_fields_to_edit", "dtbaker_pulp_image_attachment_fields_to_edit", null, 2);

function dtbaker_pulp_image_attachment_fields_to_save($post, $attachment) {
    // $attachment part of the form $_POST ($_POST[attachments][postID])
    // $post attachments wp post array - will be saved after returned
    //     $post['post_type'] == 'attachment'
    if( isset($attachment['sliderlink']) ){
        // update_post_meta(postID, meta_key, meta_value);
        update_post_meta($post['ID'], '_sliderlink', $attachment['sliderlink']);
    }
    return $post;
}
add_filter("attachment_fields_to_save", "dtbaker_pulp_image_attachment_fields_to_save", null, 2);


add_action( 'wp_enqueue_scripts', 'pulp_add_my_gallery_stylesheets' );
function pulp_add_my_gallery_stylesheets() {
    global $wp_scripts;
    if(isset($wp_scripts->registered['fancybox'])){
        // cool! we use fancybox from jigoshop (or wherever)
        add_action( 'wp_print_footer_scripts', 'pulp_dtbaker_enable_fancybox_for_gallery_shortcode' );
    }else{
        // we use thickbox.
        wp_enqueue_script( 'thickbox' );
        wp_enqueue_style( 'thickbox' );
        add_action( 'wp_print_footer_scripts', 'pulp_dtbaker_enable_thickbox_for_gallery_shortcode' );
    }
}

function pulp_dtbaker_enable_fancybox_for_gallery_shortcode() {
    print <<<EOF
<script type="text/javascript">
/* <![CDATA[ */
jQuery( document ).ready( function() {
    jQuery('.gallery-flexbox .gallery-icon a').attr('rel','pulp_gallery');
    jQuery('a[rel=pulp_gallery]').fancybox({
    'transitionIn'	: 'elastic',
		'transitionOut'	: 'elastic'
			});
});
/* ]]> */
</script>
EOF;
}
function pulp_dtbaker_enable_thickbox_for_gallery_shortcode() {

    print <<<EOF
<script type="text/javascript">
/* <![CDATA[ */
jQuery( document ).ready( function( $ ) {
    tb_init( '.gallery-flexbox .gallery-icon a' );
});
/* ]]> */
</script>
EOF;
}

add_filter('gallery_style', create_function('$a', 'return preg_replace("%<style type=\'text/css\'>(.*?)</style>%s", "", $a);'));
