<?php


/** Template Colors:

f8eba7 - background (before texture)
fbd234 - background (top fade start)
fff5bd - menu bg (before texture)
f9ba46 - button light (before texture)
a38530 - button dark (before texture)
f0ddbf - block dark (widget title bg) (before texture)
edd2a3 - widget title border bottom
faf1ba - block light (slider bg) (before texture)
fddf02 - widget content border separator
fcce62 - menu separator
f5ede2 - widget background color
edd2a3 - outer glow on banners,
fddf92 - inner banner bg color


font:
6d5316 - top right text - open 7 days.
26afb7 - menu color inactive, logo color, widget title (with white drop), top right phone, banner main text
ffbf00 - menu color active, widget alt text, banner title
edd2a3 - heading h1

  *
  */

/* our theme defaults: */

$dtbaker_theme_defaults = array(
    'color_background_color' => 'eecfa0',
    'color_background_menu' => 'FFFFFF',
    //'color_background_widget' => 'f5ede2', //'fff6c3',
    'color_background_widget_title' => 'f0ddbf',
    'color_background_widget_title_underline' => 'edd2a3',
    'color_background_content' => 'FFFFFF',
    'color_widget_separator_line' => 'eee0d7',
    'color_comments' => 'f8e6d0',
    //'color_banner_outer_glow' => 'edd2a3',
    //'color_banner_inner_color' => 'fddf92',
    // font color
    'font_color_main_body' => '000000',
    'font_color_menu_text_color' => '26afb7',
    'font_color_menu_text_color_active' => 'ffbf00',
    'font_color_headings' => '29b0b6',
    'font_color_widget_title_color' => '8b7965',
    'font_color_widget_content_color' => '6c5e51',
    'font_color_link_color' => '6c5e51',
    'font_color_link_hover_color' => 'A8895C',
    'font_color_blog_title_color' => '917b68',
    // google font
    'font_face_logo' => 'Quattrocento+Sans',
    'font_face_logosize' => '36',
    'font_face_menu' => 'Quattrocento+Sans',
    'font_face_menu_size' => '16',
    'font_face_title' => 'Quattrocento+Sans',
    'font_face_title_size_h1' => '20',
    'font_face_title_size_h2' => '18',
    'font_face_title_size_h3' => '14',
    'font_face_body' => 'PT+Sans',
    'font_face_body_size' => '13',
    'font_face_widget' => 'Quattrocento+Sans',
    'font_face_widget_title_size' => '14',
    'font_face_widget_size' => '13',
    // other
    'header_show_decal' => '1',
    'content_show_decal' => '1',
    'logo_show_decal' => '1',
    //'logo_header_text_size' => '36',
    // bg images:
    'background_image' => get_stylesheet_directory_uri().'/images/bg_tile.jpg',
    /* other settings */
    'responsive_enabled' => 1,
);


if(!function_exists('dtbaker_default_css_output')){
    function dtbaker_default_css_output($tags=true){
        global $dtbaker_theme_defaults;
        $google_fonts=dtbaker_get_google_fonts();

        // pull otu our customisations
        $dtbaker_theme_settings = array();
        foreach($dtbaker_theme_defaults as $key=>$val){
            $dtbaker_theme_settings[$key] = get_theme_mod($key,$val);
        }

        // find the used google fonts
        $used_google_fonts = array();
        foreach($dtbaker_theme_settings as $key=>$val){
            if(strpos($key,'font_face')!==false && strpos($key,'size')===false){
                if(isset($google_fonts[$val])){
                    $used_google_fonts[$val.':400'] = true;
                }else{
                    unset($dtbaker_theme_settings[$key]);
                }
            }
        }
        /*-moz-box-shadow:    inset 0 0 10px #<?php echo $dtbaker_theme_settings['color_banner_outer_glow'];?>;
               -webkit-box-shadow: inset 0 0 10px #<?php echo $dtbaker_theme_settings['color_banner_outer_glow'];?>;
               box-shadow:         inset 0 0 10px #<?php echo $dtbaker_theme_settings['color_banner_outer_glow'];?>;*/

        //print_r($dtbaker_theme_settings);
        include('style.custom.php');
    }
}

add_action('wp_before_admin_bar_render', 'pulp_add_appearance_menu');
if(!function_exists('pulp_add_appearance_menu')){
    function pulp_add_appearance_menu(){
        global $wp_admin_bar;
        $wp_admin_bar->add_menu( array( 'parent' => 'appearance', 'id' => 'customize', 'title' => __('Customize'), 'href' => wp_customize_url( get_stylesheet() ) ) );
    }
}

add_action( 'customize_save_after', 'pulp_customize_save_after', 10, 1 );
function pulp_customize_save_after($WP_Customize_Manager){
    // write our stylesheet to the cache file.
    ob_start();
    echo "/* WARNING - this file will be overwritten every time changes are saved in the Theme Customizer */\n\n\n\n";
    dtbaker_default_css_output(false);
    file_put_contents(get_template_directory().'/style.custom.css', ob_get_clean());
}
add_action( 'customize_register', 'pulp_customize_register' );
function pulp_customize_register( $wp_customize ) {
    global $dtbaker_theme_defaults;
        $done_settings=array();

    $p = 1;
        /* logo/header area */
        $wp_customize->add_section('logo_header', array(
            'title'          => __('Logo', 'pulp'),
            'priority'       => 15,
        ));
        foreach($dtbaker_theme_defaults as $key=>$val){
            if(strpos($key,'logo_')!==false && !isset($done_settings[$key])){
                if(strpos($key,'color')!==false){
                    $wp_customize->add_setting( $key , array(
                        'default'     => $val,
                        'transport'   => 'refresh',
                        'sanitize_callback'    => 'sanitize_hex_color_no_hash',
                        'sanitize_js_callback' => 'maybe_hash_hex_color',
                        'capability'     => 'edit_theme_options',
                    ) );
                    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $key,
                        array(
                            'label'        => ucwords(str_replace('_',' ',str_replace('logo_','',$key))),
                            'section' => 'logo_header',
                            'priority'       => $p++,
                        )
                    ) );
                }else{
                    $wp_customize->add_setting( $key , array(
                        'default'     => $val,
                        'transport'   => 'refresh',
                        'capability'     => 'edit_theme_options',
                    ) );
                    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, $key,
                        array(
                            'label'        => ucwords(str_replace('_',' ',str_replace('logo_','',$key))),
                            'section'    => 'logo_header',
                            'type'      => 'text',
                            'priority'       => $p++,
                        )
                    ) );
                }
                $done_settings[$key]=true;
            }
        }
        $wp_customize->add_setting('logo_header_text', array(
            'default'        => 'Pulp',
            //'type'           => 'option',
            'transport'   => 'refresh',
            'capability'     => 'edit_theme_options',
        ));
        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'logo_header_text', array(
                'label'     => __('Logo Text', 'pulp'),
                'section'   => 'logo_header',
                'type'      => 'text',
                            'priority'       => $p++,
            )
        ));
        /*$wp_customize->add_setting('logo_header_text_size', array(
            'default'        => $dtbaker_theme_defaults['logo_header_text_size'],
            //'type'           => 'option',
            'transport'   => 'refresh',
            'capability'     => 'edit_theme_options',
        ));
        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'logo_header_text_size', array(
                'label'     => __('Logo Text Size', 'pulp'),
                'section'   => 'logo_header',
                'type'      => 'text',
            )
        ));*/
        $wp_customize->add_setting('logo_header_image', array(
            'default'        => '',
            //'type'           => 'option',
            'transport'   => 'refresh',
            'capability'     => 'edit_theme_options',
        ));
        $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'logo_header_image', array(
                'label'     => __('Logo Image', 'pulp'),
                'section'   => 'logo_header',
                            'priority'       => $p++,
            )
        ));
        $wp_customize->add_setting('logo_header_image_width', array(
            'default'        => '135',
            'transport'   => 'refresh',
            'capability'     => 'edit_theme_options',
        ));
        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'logo_header_image_width', array(
                'label'     => __('Logo Image Width', 'pulp'),
                'section'   => 'logo_header',
                'type'      => 'text',
                            'priority'       => $p++,
            )
        ));

        $wp_customize->add_setting( 'logo_show_decal', array(
            'default'        => $dtbaker_theme_defaults['logo_show_decal'],
            'transport'   => 'refresh',
            'capability'     => 'edit_theme_options',
        ) );
        $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'logo_show_decal', array(
            'label'   => __( 'Enable Logo Background','pulp' ),
            'type' => 'select',
            'choices' => array(
                1 => "Yes",
                0 => "No",
            ),
            'section' => 'logo_header',
                            'priority'       => $p++,
        ) ) );


        $google_fonts=dtbaker_get_google_fonts();
        ksort($google_fonts);
        foreach($google_fonts as $key=>$val){
            $google_fonts[$key] = $val[0];
        }


        /* font face */
        $wp_customize->add_section( 'pulp_font' , array(
            'title'      => __('Font Styles','mytheme'),
            //'priority'   => 30,
        ) );
        foreach($dtbaker_theme_defaults as $key=>$val){
            if(strpos($key,'font_face')!==false && !isset($done_settings[$key])){
                if(strpos($key,'size')){
                    $wp_customize->add_setting($key, array(
                        'default'        => $dtbaker_theme_defaults[$key],
                        'transport'   => 'refresh',
                        'capability'     => 'edit_theme_options',
                    ));
                    $wp_customize->add_control(new WP_Customize_Control($wp_customize, $key, array(
                            'label'     => ucwords(str_replace('_',' ',str_replace('font_face_','',$key))),
                            'section'   => 'pulp_font',
                            'type'      => 'text',
                            'priority'       => $p++,
                        )
                    ));
                }else{
                    $wp_customize->add_setting( $key , array(
                        'default'     => $val,
                        'transport'   => 'refresh',
                        'capability'     => 'edit_theme_options',
                    ) );
                    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, $key,
                        array(
                            'label'        => ucwords(str_replace('_',' ',str_replace('font_face_','',$key))),
                            'section'    => 'pulp_font',
                            'type'      => 'select',
                            'choices'   => $google_fonts,
                            'priority'       => $p++,
                        )
                    ) );
                }
                $done_settings[$key]=true;
            }
        }

        /* responsive on/off switch */
    $wp_customize->add_section( 'pulp_responsive' , array(
            'title'      => __('Responsive','mytheme'),
            //'priority'   => 30,
        ) );
                $wp_customize->add_setting( 'responsive_enabled' , array(
                    'default'     => $dtbaker_theme_defaults['responsive_enabled'],
                    'transport'   => 'refresh',
                    'capability'     => 'edit_theme_options',
                ) );
                $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'responsive_enabled',
                    array(
                        'label'        => 'Enable Responsive',
                        'section'    => 'pulp_responsive',
                        'type'      => 'select',
                        'choices'   => array(
                            1 => __('Enabled','pulp'),
                            0 => __('Disabled','pulp'),
                        ),
                            'priority'       => $p++,
                    )
                ) );
                $done_settings['responsive_enabled']=true;

        /* font colors */
        $wp_customize->add_section( 'pulp_font_color' , array(
            'title'      => __('Font Colors','mytheme'),
            //'priority'   => 30,
        ) );
        foreach($dtbaker_theme_defaults as $key=>$val){
            if(strpos($key,'font_color_')!==false && !isset($done_settings[$key])){
                $wp_customize->add_setting( $key , array(
                    'default'     => $val,
                    'transport'   => 'refresh',
                    'sanitize_callback'    => 'sanitize_hex_color_no_hash',
                    'sanitize_js_callback' => 'maybe_hash_hex_color',
                    'capability'     => 'edit_theme_options',
                ) );
                $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $key,
                    array(
                        'label'        => ucwords(str_replace('_',' ',str_replace('font_color_','',$key))),
                        'section' => 'pulp_font_color',
                            'priority'       => $p++,
                    )
                ) );
                $done_settings[$key]=true;
            }
        }
        /* background colors */
        $wp_customize->add_section( 'pulp_background' , array(
            'title'      => __('Background','mytheme'),
            //'priority'   => 30,
        ) );

        $wp_customize->add_setting( 'header_show_decal', array(
            'default'        => $dtbaker_theme_defaults['header_show_decal'],
            'transport'   => 'refresh',
            'capability'     => 'edit_theme_options',
        ) );
        $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'header_show_decal', array(
            'label'   => __( 'Enable Menu Sun/Clouds','pulp' ),
            'type' => 'select',
            'choices' => array(
                1 => "Yes",
                0 => "No",
            ),
            'section' => 'pulp_background',
                            'priority'       => $p++,
        ) ) );
        $wp_customize->add_setting( 'content_show_decal', array(
            'default'        => $dtbaker_theme_defaults['content_show_decal'],
            'transport'   => 'refresh',
            'capability'     => 'edit_theme_options',
        ) );
        $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'content_show_decal', array(
            'label'   => __( 'Enable Jagged Header/Footer','pulp' ),
            'type' => 'select',
            'choices' => array(
                1 => "Yes",
                0 => "No",
            ),
            'section' => 'pulp_background',
                            'priority'       => $p++,
        ) ) );
       /* $wp_customize->add_setting( 'background_show_fuzz', array(
            'default'        => $dtbaker_theme_defaults['background_show_fuzz'],
            'transport'   => 'refresh',
            'capability'     => 'edit_theme_options',
        ) );
        $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'background_show_fuzz', array(
            'label'   => __( 'Background Grainy' ),
            'type' => 'select',
            'choices' => array(
                1 => "Yes",
                0 => "No",
            ),
            'section' => 'pulp_background',
        ) ) );*/


        foreach(array('color_background_color') as $key){ //'color_background_fade_top'
            $wp_customize->add_setting( $key , array(
                'default'     => $dtbaker_theme_defaults[$key],
                'transport'   => 'refresh',
                'sanitize_callback'    => 'sanitize_hex_color_no_hash',
                'sanitize_js_callback' => 'maybe_hash_hex_color',
                'capability'     => 'edit_theme_options',
            ) );
            $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $key,
                array(
                    'label'        => ucwords(str_replace('_',' ',str_replace('color_','',$key))),
                    'section' => 'pulp_background',
                            'priority'       => $p++,
                )
            ) );
            $done_settings[$key]=true;
        }


    /* background images */

        $wp_customize->add_setting('background_image', array(
            'default'        => $dtbaker_theme_defaults['background_image'],
            'transport'   => 'refresh',
            'capability'     => 'edit_theme_options',
        ));
        $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'background_image', array(
                'label'     => __('Background Image', 'pulp'),
                'section'   => 'pulp_background',
                            'priority'       => $p++,
            )
        ));

        /* site colors */
        $wp_customize->add_section( 'pulp_other_color' , array(
            'title'      => __('Other Colors','mytheme'),
            //'priority'   => 30,
        ) );
        foreach($dtbaker_theme_defaults as $key=>$val){
            if(strpos($key,'color_')!==false && !isset($done_settings[$key])){
                $wp_customize->add_setting( $key , array(
                    'default'     => $val,
                    'transport'   => 'refresh',
                    'sanitize_callback'    => 'sanitize_hex_color_no_hash',
                    'sanitize_js_callback' => 'maybe_hash_hex_color',
                    'capability'     => 'edit_theme_options',
                ) );
                $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $key,
                    array(
                        'label'        => ucwords(str_replace('_',' ',str_replace('color_','',$key))),
                        'section' => 'pulp_other_color',
                            'priority'       => $p++,
                    )
                ) );
                $done_settings[$key]=true;
            }
        }




}


add_action('admin_menu', 'dtbaker_add_theme_page');
//add_action('publish_page', 'dtbaker_savepagecustom');
//add_action('publish_post', 'dtbaker_savepagecustom');

function dtbakerfoo(){return 'dtba';}
function dtbaker_add_theme_page() {
    if ( isset( $_REQUEST['update_settings'] ) && 'true' == $_REQUEST['update_settings'] ) {
        check_admin_referer('dtbaker-header');
        // save all options:
        $data = $_POST;
        foreach($data as $key=>$val){
            if(is_array($val))continue;
            if(preg_match('/^'.dtbakerfoo().'ker/',$key)){
                set_theme_mod($key,$val);
            }
        }

        if(isset($data['default_content']) && is_array($data['default_content'])){
            if(isset($data['default_content']['home_page'])&&$data['default_content']['home_page']){
                // set the home page.
                $page = get_page_by_title('Home Page');
                if($page && $page->ID){
                    update_option('show_on_front','page');
                    update_option('page_on_front',$page->ID);
                    $page = get_page_by_title('Blog Page');
                    if($page && $page->ID){
                        update_option('page_for_posts',$page->ID);
                    }
                }
            }
            if(isset($data['default_content']['woocommerce'])){
                // if woocommerce is enabled we also set the default pages, if they're not already defined.
                if(function_exists('woocommerce_compile_less_styles')){

                    //$default_colors = get_option('woocommerce_frontend_css_colors');
                    // primary

                    /* [primary] => #ad74a2
                    [secondary] => #f7f6f7
                    [highlight] => #85ad74
                    [content_bg] => #ffffff
                    [subtext] => #777777 */
                    //if(!$default_colors || !$default_colors['primary'] || $default_colors['primary'] == '#ad74a2'){
                        // change default to our settings:
                        update_option('woocommerce_frontend_css_colors',array(
                            'primary' => '#f0ddbf', // our button dark color
                            'secondary' => '#f7f6f7', //'desaturate(lighten(@primary,50%),18%),', //'#fbd944', // button light
                            'highlight' => '#ffbd00',//'#85ad74',
                            'content_bg' => '#ffffff',
                            'subtext' => '#777777',
                        ));
                        woocommerce_compile_less_styles();
                    //}
                }
                if(function_exists('woocommerce_admin_init')){
                    $_GET['install_woocommerce_pages'] = 'yep!';
                    woocommerce_admin_init(); /// this should hunt down existing pages matching slugs and link them up.
                }
            }
            if(isset($data['default_content']['menu'])&&$data['default_content']['menu']){
                $menus = get_terms('nav_menu');
                $save = array();
                foreach($menus as $menu){
                    if($menu->name == 'Main'){
                        $save['primary'] = $menu->term_id;
                    }else if($menu->name == 'Footer'){
                        $save['footer'] = $menu->term_id;
                    }
                }
                if($save){
                    set_theme_mod( 'nav_menu_locations', array_map( 'absint', $save ) );
                }
            }
            if(isset($data['default_content']['widgets'])&&$data['default_content']['widgets']){
                $export = false;
                if($export){
                    // used for me to export my widget settings.
                    $widget_positions = get_option('sidebars_widgets');
                    $widget_options = array();
                    $my_options = array();
                    foreach($widget_positions as $sidebar_name => $widgets){
                        if(is_array($widgets)){
                            foreach($widgets as $widget_name){
                                $widget_name_strip = preg_replace('#-\d+$#','',$widget_name);
                                $widget_options[$widget_name_strip] = get_option('widget_'.$widget_name_strip);
                            }
                        }
                    }
                    $a = base64_encode(serialize($widget_positions));
                    $b = base64_encode(serialize($widget_options));
                    // export the widget area manager options.
                    $all_options = wp_load_alloptions();
                    foreach( $all_options as $name => $value ) {
                        if(stristr($name, '_widget_area_manager')) $my_options[$name] = $value;
                    }
                    $c = base64_encode(serialize($my_options));
                    echo "widget_positions: \n\n\n$a\n\n\n widget_options \n\n\n$b\n\n\n my_options \n\n\n$c\n\n\n";
                    exit;
                }else{
                    // importing.
                    $widget_positions = get_option('sidebars_widgets');

                    $import_widget_positions = unserialize(base64_decode($_REQUEST['widget_positions']));
                    $import_widget_options = unserialize(base64_decode($_REQUEST['widget_options']));
                    $my_options = unserialize(base64_decode($_REQUEST['my_options']));
                    //echo '<pre>'; print_r($import_widget_positions); print_r($import_widget_options); print_r($my_options); echo '</pre>';exit;
                    foreach($import_widget_options as $widget_name => $widget_options){
                        $existing_options = get_option('widget_'.$widget_name,array());
                        $new_options = $existing_options + $widget_options;
//                        echo $widget_name;
//                        print_r($new_options);
                        update_option('widget_'.$widget_name,$new_options);
                    }
                    update_option('sidebars_widgets',array_merge($widget_positions,$import_widget_positions));
//                    print_r($widget_positions + $import_widget_positions);exit;
                    // we also want to update the widget area manager options.
                    foreach($my_options as $option => $value){
                        update_option($option, $value);
                    }

                }
            }
        }

        wp_redirect("themes.php?page=".basename($_GET['page'])."&saved=true");
        die;
    }
    add_theme_page(__('Options: ThemeForest','pulp'), __('Options: ThemeForest','pulp'), 'edit_themes', 'dtbaker.theme_options_envato.php', 'dtbaker_theme_page_envato');
    //add_theme_page(__('Options: Logo/Header','pulp'), __('Options: Logo/Header','pulp'), 'edit_themes', 'dtbaker.theme_options_logo.php', 'dtbaker_theme_page_logo');
    //add_theme_page(__('Options: Font','pulp'), __('Options: Font','pulp'), 'edit_themes', 'dtbaker.theme_options_font.php', 'dtbaker_theme_page_font');
    add_theme_page(__('Default Content','pulp'), __('Default Content','pulp'), 'edit_themes', 'dtbaker.theme_options_default.php', 'dtbaker_theme_page_default');


}


//require_once("dtbaker.theme_options_default.php");
//require_once("dtbaker.theme_options_logo.php");
//require_once("dtbaker.theme_options_font.php");
require_once("dtbaker.theme_options_envato.php");
require_once("dtbaker.theme_options_default.php");