<?php

// this overwrites the widget class and gives each widget area a new option to control the background color
add_filter('widget_display_callback', 'pulp_widget_display_callback', 11, 3);
function pulp_widget_display_callback($instance, $widget, $args) {
    if (!isset($instance['pulp_widget_bg'])) {
        return $instance;
    }
    $widget_classname = $widget->widget_options['classname'];
    switch($instance['pulp_widget_bg']){
        case 'transparent':
            $my_classname = 'widget_transparent';
            break;
        case 'color':
            $my_classname = 'widget_custom_color';
            $args['before_widget'] = str_replace('<div id','<div style="background-color: #'.$instance['pulp_widget_bg_custom'].';" id',$args['before_widget']);
            break;
        case 'light':
            $my_classname = 'widget_light';
            break;
        default:
            $my_classname = 'widget_dark';
    }

    $args['before_widget'] = str_replace($widget_classname, "$widget_classname $my_classname", $args['before_widget']);
    $widget->widget($args, $instance);
    return false;
}
add_action('widget_update_callback','pulp_widget_update_callback',11, 2);
function pulp_widget_update_callback($instance, $new_instance) {
    $instance['pulp_widget_bg'] = $new_instance['pulp_widget_bg'];
    $instance['pulp_widget_bg_custom'] = $new_instance['pulp_widget_bg_custom'];
    return $instance;
}
add_action('in_widget_form', 'pulp_in_widget_form', 10, 1);
function pulp_in_widget_form($widget_instance) {
    $settings = $widget_instance->get_settings();
    $settings = isset($widget_instance->number) && isset($settings[$widget_instance->number]) ? $settings[$widget_instance->number] : array();
    ?>
  <label for="<?php echo $widget_instance->get_field_id('pulp_widget_bg'); ?>"><?php _e('Widget Background','pulp');?>:</label>
    <select name="<?php echo $widget_instance->get_field_name('pulp_widget_bg'); ?>" id="<?php echo $widget_instance->get_field_id('pulp_widget_bg'); ?>" onchange="if(jQuery(this).val() == 'color') jQuery('#<?php echo $widget_instance->get_field_id('pulp_widget_bg_custom'); ?>').show(); else jQuery('#<?php echo $widget_instance->get_field_id('pulp_widget_bg_custom'); ?>').hide();">
        <option value="dark" <?php echo (!isset($settings['pulp_widget_bg']) || (isset($settings['pulp_widget_bg']) && $settings['pulp_widget_bg'] == 'dark')) ? 'selected' : '';?>><?php _e('Default','pulp');?></option>
        <option value="color" <?php echo (isset($settings['pulp_widget_bg']) && $settings['pulp_widget_bg'] == 'color') ? 'selected' : '';?>><?php _e('Custom Color','pulp');?></option>
        <option value="light" <?php echo (isset($settings['pulp_widget_bg']) && $settings['pulp_widget_bg'] == 'light') ? 'selected' : '';?>><?php _e('White','pulp');?></option>
        <option value="transparent" <?php echo (isset($settings['pulp_widget_bg']) && $settings['pulp_widget_bg'] == 'transparent') ? 'selected' : '';?>><?php _e('Transparent','pulp');?></option>
    </select>
    <span id="<?php echo $widget_instance->get_field_id('pulp_widget_bg_custom'); ?>" style="<?php echo !isset($settings['pulp_widget_bg']) || $settings['pulp_widget_bg'] != 'color' ? 'display:none;' : '';?>">
    #<input type="text" name="<?php echo $widget_instance->get_field_name('pulp_widget_bg_custom'); ?>"  value="<?php echo esc_attr($settings['pulp_widget_bg_custom']);?>" style="width:53px;"> <?php _e('(enter hex code)','pulp');?>
    </span>
  <?php
}


function pulp_widgets_init() {

    // we pass widget registration off to the widget_area_manager plugin.

    // add layout areas (ie: areas that can contain the widgets)
    do_action('widget_area_add_layouts',array(


        /**
         * The main widget area.
         * This displays on the left or right of every page on the website.
         * It can also be "hidden", when hidden the page goes to full width.
         */
        'main' => array(
            'name' => 'Left/Right Column',
            'default_widget_area' => array(
                'all'=>'main', // the main default area used for all pages
            ),
            'default_position' => array(
                'all'=>'pos_right', // change to pos_left or hidden if you like.
            ),
            'positions' => array(
                'pos_left' => array(
                    'name' => 'Left',
                    // hooks that are called from in our template with something like:
                    // do_action('widget_area_manager_hook','before_content');
                    // the special {WIDGETS} string will contain the selected widget_area
                    'content_top' => ' <div class="content_main with-left-sidebar">',
                    'content_bottom' => '</div> <div class="sidebar sidebar-left widget-area" role="complementary">{WIDGETS}</div>',
                ),
                'pos_right' => array(
                    'name' => 'Right',
                    // hooks that are called from in our template with something like:
                    // do_action('widget_area_manager_hook','before_content');
                    // the special {WIDGETS} string will contain the selected widget_area
                    'content_top' => ' <div class="content_main with-right-sidebar">',
                    'content_bottom' => '</div> <div class="sidebar sidebar-right widget-area" role="complementary">{WIDGETS}</div>',
                ),
                'pos_hidden' => array(
                    'name' => 'Hidden',
                    // hooks that are called from in our template with something like:
                    // do_action('widget_area_manager_hook','before_content');
                    // the special {WIDGETS} string will contain the selected widget_area
                    'content_top' => '<div class="content_main no_sidebar">',
                    'content_bottom' => '<div class="clear"></div></div>',
                ),
            ),
        ),
        /**
         * The above_content area directly under the top banner.
         * They can place a full width slider here if they want.
         */
        'above_content' => array(
            'name' => 'Header',
            'default_widget_area' => array(
                'all' => 'header_widgets1',
            ),
            'default_position' => array(
                'all' => 'pos_hidden',
            ),
            'positions' => array(
                'pos_full' => array(
                    'name' => 'Full Page Width',
                    // hooks that are called from in our template with something like:
                    // do_action('widget_area_manager_hook','before_content');
                    // the special {WIDGETS} string will contain the selected widget_area
                    'content_full_page' => '<div id="widget_area_top" class="widget-area columns-1" role="complementary">{WIDGETS}</div>',
                ),
                'pos_columns' => array(
                    'name' => '3 Columns',
                    // hooks that are called from in our template with something like:
                    // do_action('widget_area_manager_hook','before_content');
                    // the special {WIDGETS} string will contain the selected widget_area
                    'content_full_page' => '<div id="widget_area_top" class="widget-area columns-3" role="complementary">{WIDGETS}<span class="stretch"></span></div>',
                ),
                'pos_hidden' => array(
                    'name' => 'Hidden',
                ),
            ),
        ),
        /**
         * Along the footer of the content area.
         */
        'footer' => array(
            'name' => 'Footer',
            'default_widget_area' => 'footerarea1',
            'default_position' => 'pos_3',
            'positions' => array(
                'pos_full' => array(
                    'name' => 'Full Page Width',
                    // hooks that are called from in our template with something like:
                    // do_action('widget_area_manager_hook','before_content');
                    // the special {WIDGETS} string will contain the selected widget_area
                    'footer' => '<div id="footer_widgets"><div class="widget-area columns-1" role="complementary">{WIDGETS}</div></div>',
                ),
                'pos_columns' => array(
                    'name' => '3 Columns',
                    // hooks that are called from in our template with something like:
                    // do_action('widget_area_manager_hook','before_content');
                    // the special {WIDGETS} string will contain the selected widget_area
                    'footer' => '<div id="footer_widgets"><div class="widget-area columns-3" role="complementary">{WIDGETS}<span class="stretch"></span></div></div>'
                ),
                'pos_hidden' => array(
                    'name' => 'Hidden',
                    'footer' => '',
                ),
            ),
        ),
        /** end hook area config */
    ));

    // add the sidebars:
    $sidebars = array();

    // main sidebar, for the left/right area.
    $sidebars['main'] = array(
        'name' => __( "Sidebar Column #1", 'pulp' ),
        'description' => 'This is the default widget group that can be displayed on the left or right of every page.',
        'id' => 'main',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => "</div> ",
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3><div class="widget-title-spacer"></div> ',
    );


    $number = get_option('_dtbaker_theme_optional_widget_count',8);
    for($x=2;$x<=$number;$x++){
        $sidebars['widget_area-'.$x] = array(
            'name' => 'Sidebar Column #'.$x,
            'id' => 'widget_area-'.$x,
            'description' => 'An empty sidebar for use on any page',
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget' => "</div> ",
            'before_title' => '<h3 class="widget-title">',
            'after_title' => '</h3><div class="widget-title-spacer"></div> ',
        );
    }


    /// the small header widget area:
    $sidebars['header_widgets1'] = array(
        'name' => __( "Header Widgets #1", 'pulp' ),
        'description' => 'This widget area is used to display a series of widgets at the top of the website (just under the menu).',
        'id' => 'header_widgets1',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => "</div> ",
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3><div class="widget-title-spacer"></div> ',
    );
    $sidebars['header_widgets2'] = array(
        'name' => __( "Header Widgets #2", 'pulp' ),
        'description' => 'This widget area is used to display a series of widgets at the top of the website (just under the menu)',
        'id' => 'header_widgets2',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => "</div> ",
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3><div class="widget-title-spacer"></div> ',
    );


    $sidebars['footerarea1'] = array(
        'name' => __( "Footer Area #1", 'pulp' ),
        'description' => 'This is the widget group that can be displayed at the very bottom of the website.',
        'id' => 'footerarea1',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => "</div> ",
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3><div class="widget-title-spacer"></div> ',
    );
    $sidebars['footerarea2'] = array(
        'name' => __( "Footer Area #2", 'pulp' ),
        'description' => 'This is the widget group that can be displayed at the very bottom of the website.',
        'id' => 'footerarea2',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => "</div> ",
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3><div class="widget-title-spacer"></div> ',
    );


    do_action('widget_area_add_sidebars',$sidebars);
}
add_action( 'widgets_init', 'pulp_widgets_init' );




foreach(glob( dirname(__FILE__)."/widgets/*.php" ) as $filename) include_once($filename);

