<?php
/**
 * pulp functions and definitions
 *
 * */

define('DONOTMINIFY',true);

function pulp_theme_add_editor_styles() {
    add_editor_style( 'style.editor.css' );
}
add_action( 'init', 'pulp_theme_add_editor_styles' );


add_action( 'wp_enqueue_scripts', 'pulp_add_my_stylesheets' );
function pulp_add_my_stylesheets() {

//    $themes = wp_get_themes(); print_r($themes);

    /* REGISTER */
    wp_register_style( 'pulp_css', get_stylesheet_directory_uri().'/style.css' );
    if(get_theme_mod('responsive_enabled',1)){
        wp_register_style( 'pulp_media', get_stylesheet_directory_uri().'/style.responsive.css' );
    }
    wp_register_style( 'pulp_css_blog', get_stylesheet_directory_uri().'/style.blog.css' );
    wp_register_style( 'pulp_comments_css', get_stylesheet_directory_uri().'/style.comments.css' );
    wp_register_style( 'pulp_wpcf7_css', get_stylesheet_directory_uri().'/style.wpcf7.css' );
    if(class_exists('WooCommerce',false)){
        wp_register_style( 'pulp_woocommerce', get_stylesheet_directory_uri().'/style.woocommerce.css', array('woocommerce_frontend_styles') );
    }
    wp_register_script( 'pulp_javascript', get_stylesheet_directory_uri().'/js/javascript.js');
    $params = array(
        'do_animate_sun' => get_theme_mod('animate_sun',1) ? 1 : 0
    );
    // the position of our various background elements, from the top-middle of the page to the left or right.
    $params['backgrounds'] = array(
        array(
            get_template_directory_uri().'/images/background_balloon.png', // image
            260, // px from top
            570, // px from middle
            108, // px image width
            141, // px image height
        ),
        array(
            get_template_directory_uri().'/images/background_cloud5.png', // image
            191, // px from top
            546, // px from middle
            77, // px image width
            35, // px image height
        ),
        array(
            get_template_directory_uri().'/images/background_cloud4.png', // image
            290, // px from top
            705, // px from middle
            116, // px image width
            64, // px image height
        ),
        array(
            get_template_directory_uri().'/images/background_cloud3.png', // image
            423, // px from top
            -782, // px from middle
            272, // px image width
            129, // px image height
        ),
        array(
            get_template_directory_uri().'/images/background_cloud2.png', // image
            498, // px from top
            523, // px from middle
            155, // px image width
            116, // px image height
        ),
        array(
            get_template_directory_uri().'/images/background_cloud2.png', // image
            230, // px from top
            -686, // px from middle
            155, // px image width
            116, // px image height
        ),
        array(
            get_template_directory_uri().'/images/background_kite.png', // image
            65, // px from top
            -617, // px from middle
            120, // px image width
            155, // px image height
        ),
    );
    wp_localize_script( 'pulp_javascript', 'pulp_params', $params );

    /* ENQUEUE */
    if ( is_singular() ){
        wp_enqueue_script( 'comment-reply' );
        wp_enqueue_style( 'pulp_comments_css' );
    }
    wp_enqueue_script("jquery");
    wp_enqueue_script("jquery-ui-core");
    wp_enqueue_script( 'pulp_javascript' );
    wp_enqueue_style( 'pulp_css' );
    wp_enqueue_style( 'pulp_css_blog' ); // wrap a conditional tag around this?
    wp_enqueue_style( 'pulp_wpcf7_css' ); // wrap a conditional tag around this?
    if(class_exists('WooCommerce',false)){
        wp_enqueue_style( 'pulp_woocommerce' );
    }
    if(get_theme_mod('responsive_enabled',1)){
        wp_enqueue_style( 'pulp_media' );
    }

    /* GOOGLE FONT */
    global $dtbaker_theme_defaults;
    $dtbaker_theme_settings = array();
    foreach($dtbaker_theme_defaults as $key=>$val){
        $dtbaker_theme_settings[$key] = get_theme_mod($key,$val);
    }

    // find the google fonts
    $google_fonts=dtbaker_get_google_fonts();
    $used_google_fonts = array();
    foreach($dtbaker_theme_settings as $key=>$val){
        if(strpos($key,'font_face')!==false){
            if(isset($google_fonts[$val])){
                $used_google_fonts[$val.':400'] = true;
            }else{
                unset($dtbaker_theme_settings[$key]);
            }
        }
    }
    $css_url = 'http://fonts.googleapis.com/css?family=';
    $css_url .= implode('|',array_keys($used_google_fonts));
    wp_register_style( 'pulp_google_font',$css_url );
    wp_enqueue_style( 'pulp_google_font' );


    // time to enqueue our custom stylesheet
    // we fall back to printing this out in 'head' if our file write permissions are not available.
    $dynamic_file = 'style.custom.css';
    $dynamic_file_path = get_template_directory().'/'.$dynamic_file;
    $css_data = file_exists($dynamic_file_path) ? file_get_contents($dynamic_file_path) : '';
    global $wp_customize;
    if((isset($wp_customize) && $wp_customize && $wp_customize->is_preview()) || strlen($css_data)<100){
        // failed to write dynamic file yet, output it raw to the header.
        // call to function in dtbaker.theme_options.php
        function dtbaker_default_css_output_c(){
            dtbaker_default_css_output(true);
        }
        add_action('wp_head','dtbaker_default_css_output_c');
    }else{
        // otherwise we load up our custom stylesheet like normal
        wp_register_style( 'pulp_dynamic', get_template_directory_uri().'/'.$dynamic_file );
        wp_enqueue_style( 'pulp_dynamic' );
    }

}


/**
 * Tell WordPress to run pulp_setup() when the 'after_setup_theme' hook is run.
 */
add_action( 'after_setup_theme', 'pulp_setup' );

if ( ! function_exists( 'pulp_setup' ) ):
function pulp_setup() {

	/* Make pulp available for translation.
	 * Translations can be added to the /languages/ directory.
	 * If you're building a theme based on pulp, use a find and replace
	 * to change 'pulp' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'pulp', get_template_directory() . '/languages' );

	$locale = get_locale();
	$locale_file = get_template_directory() . "/languages/$locale.php";
	if ( is_readable( $locale_file ) )
		require_once( $locale_file );

	// This theme styles the visual editor with editor-style.css to match the theme style.
	//add_editor_style();

	// Add default posts and comments RSS feed links to <head>.
	add_theme_support( 'automatic-feed-links' );
    add_theme_support( 'woocommerce' );
    add_theme_support( 'jigoshop' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menu( 'primary', __( 'Primary Menu', 'pulp' ) );
	register_nav_menu( 'footer', __( 'Footer Menu', 'pulp' ) );

	// Add support for custom backgrounds
	//add_custom_background('dtbaker_set_custom_background_defaults');
    /*$repeat = get_theme_mod( 'background_repeat', 'notset' );
    if($repeat=='notset'){
        set_theme_mod('background_repeat','repeat-x');
    }
    $background_color = get_theme_mod( 'background_color', 'notset' );
    if($background_color=='notset'){
        set_theme_mod('background_color','f8eba7');
    }
    $args = array(
        //'default-color' => 'EDF7FF',
        'default-image' => get_stylesheet_directory_uri() . '/images/page_bg.jpg',
    );
    add_theme_support( 'custom-background', $args );*/
    //background-image:url(images/page_bg_stripe.jpg);

	// This theme uses Featured Images (also known as post thumbnails) for per-post/per-page Custom Header images
	add_theme_support( 'post-thumbnails' );

	// The next four constants set how pulp supports custom headers.
	// The default header text color
	//define( 'HEADER_TEXTCOLOR', '000' );
	//define( 'HEADER_IMAGE', '' );
	// The height and width of your custom header.
	// Add a filter to pulp_header_image_width and pulp_header_image_height to change these values.
	//define( 'HEADER_IMAGE_WIDTH', apply_filters( 'pulp_header_image_width', 1000 ) );
	//define( 'HEADER_IMAGE_HEIGHT', apply_filters( 'pulp_header_image_height', 288 ) );
	define( 'THUMB_IMAGE_WIDTH', 590 );
	define( 'THUMB_IMAGE_HEIGHT', 300 );

	set_post_thumbnail_size( THUMB_IMAGE_WIDTH, 0, true );

	// Add pulp's custom image sizes
	add_image_size( 'insideblog', 590);  // for fancy posts
	add_image_size( 'fancy', 315, 128, true);  // for fancy posts
    add_image_size( 'fancy3', 268, 128, true);  // for fancy posts






}
endif; // pulp_setup



function foo_widget_title( $title = '', $instance = '', $id_base = '' ) {
    if ( 'calendar' == $id_base && '&nbsp;' == $title )
        $title = '';
    return $title;
}
add_filter('widget_title', 'foo_widget_title', 5, 3);
/*
function dtbaker_set_custom_background_defaults(){
    $bgimage = get_background_image();
    $bgcolor = get_background_color();


    echo "<style type='text/css'>\n";

    if(!empty($bgimage)) {
        $background_styles = 'background-image: url(\'' . get_theme_mod('background_image', '') . '\');'
            . ' background-repeat: ' . get_theme_mod('background_repeat', 'repeat') . ';'
            . ' background-position: top ' . get_theme_mod('background_position_x', 'left') .  ';' . 'background-attachment: '. get_theme_mod('background_attachment', 'scroll');
        echo "body { ".$background_styles."); } \n";
    }
    if(!empty($bgcolor)) {
        echo "body { background-color: #".$bgcolor."; }; \n";
    }
    if(empty($bgimage) && empty($bgcolor)) {
        echo "body { background-image: url(".get_template_directory_uri()."/images/page_bg_stripe.jpg); }\n";
    }
    echo "</style>";
}
*/
/**
 * Tell WordPress to run pulp_init() when the 'init' hook is run
 */
add_action( 'init', 'pulp_init' );

if ( ! function_exists( 'pulp_init' ) ):
/**
 *
 * To override pulp_init() in a child theme, add your own pulp_init to your child theme's
 * functions.php file.
 *
 * @since pulp 1.0
 */
function pulp_init() {



}
endif; // pulp_init



/**
 * Sets the post excerpt length to 40 words.
 *
 * To override this length in a child theme, remove the filter and add your own
 * function tied to the excerpt_length filter hook.
 */
function pulp_excerpt_length( $length ) {
	return 40;
}
add_filter( 'excerpt_length', 'pulp_excerpt_length' );

/**
 * Returns a "Continue Reading" link for excerpts
 */
function pulp_continue_reading_link() {
	return ' <a href="'. esc_url( get_permalink() ) . '">' . __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'pulp' ) . '</a>';
}


/**
 * Get our wp_nav_menu() fallback, wp_page_menu(), to show a home link.
 */
function pulp_page_menu_args( $args ) {
	$args['show_home'] = true;
	return $args;
}
add_filter( 'wp_page_menu_args', 'pulp_page_menu_args' );


/**
 * Display navigation to next/previous pages when applicable
 */
function pulp_content_nav( $nav_id ) {
	global $wp_query;

	if ( $wp_query->max_num_pages > 1 ) : ?>
		<nav id="<?php echo $nav_id; ?>" class="navigation  ">
			<h3 class="assistive-text"><?php _e( 'Post navigation', 'pulp' ); ?></h3>
			<div class="nav-previous"><?php previous_posts_link( __( '&larr; Back', 'pulp' ) ); ?></div>
			<div class="nav-next"><?php next_posts_link( __( 'Next &rarr;', 'pulp' ) ); ?></div>
		</nav><!-- #nav-above -->
	<?php endif;
}



if ( ! function_exists( 'pulp_comment' ) ) :
/**
 * Template for comments and pingbacks.
 *
 * To override this walker in a child theme without modifying the comments template
 * simply create your own pulp_comment(), and that function will be used instead.
 *
 * Used as a callback by wp_list_comments() for displaying the comments.
 *
 * @since pulp 1.0
 */
function pulp_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case 'pingback' :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php _e( 'Pingback:', 'pulp' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( __( 'Edit', 'pulp' ), '<span class="edit-link">', '</span>' ); ?></p>
	<?php
			break;
		default :
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div id="comment-<?php comment_ID(); ?>" class="comment">
			<div class="comment-meta">
				<div class="comment-author vcard">
					<?php
						$avatar_size = 68;
						if ( '0' != $comment->comment_parent )
							$avatar_size = 39;

						echo get_avatar( $comment, $avatar_size );

						/* translators: 1: comment author, 2: date and time */
						printf( __( '%1$s on %2$s <span class="says">said:</span>', 'pulp' ),
							sprintf( '<span class="fn">%s</span>', get_comment_author_link() ),
							sprintf( '<a href="%1$s"><time pubdate datetime="%2$s">%3$s</time></a>',
								esc_url( get_comment_link( $comment->comment_ID ) ),
								get_comment_time( 'c' ),
								/* translators: 1: date, 2: time */
								sprintf( __( '%1$s at %2$s', 'pulp' ), get_comment_date(), get_comment_time() )
							)
						);
					?>

					<?php edit_comment_link( __( 'Edit', 'pulp' ), '<span class="edit-link">', '</span>' ); ?>
				</div><!-- .comment-author .vcard -->

				<?php if ( $comment->comment_approved == '0' ) : ?>
					<em class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'pulp' ); ?></em>
					<br />
				<?php endif; ?>

			</div>

			<div class="comment-content"><?php comment_text(); ?></div>

			<div class="reply">
				<?php comment_reply_link( array_merge( $args, array( 'reply_text' => __( 'Reply <span>&darr;</span>', 'pulp' ), 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
			</div><!-- .reply -->
		</div><!-- #comment-## -->

	<?php
			break;
	endswitch;
}
endif; // ends check for pulp_comment()

if ( ! function_exists( 'pulp_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
 * Create your own pulp_posted_on to override in a child theme
 *
 * @since pulp 1.0
 */
function pulp_posted_on() {
	printf( __( '<span class="sep">Posted on </span><a href="%1$s" title="%2$s" rel="bookmark"><time class="entry-date" datetime="%3$s" pubdate>%4$s</time></a><span class="by-author"> <span class="sep"> by </span> <span class="author vcard"><a class="url fn n" href="%5$s" title="%6$s" rel="author">%7$s</a></span></span>', 'pulp' ),
		esc_url( get_permalink() ),
		esc_attr( get_the_time() ),
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() ),
		esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
		sprintf( esc_attr__( 'View all posts by %s', 'pulp' ), get_the_author() ),
		esc_html( get_the_author() )
	);
}
endif;

/**
 * Adds two classes to the array of body classes.
 * The first is if the site has only had one author with published posts.
 * The second is if a singular post being displayed
 *
 * @since pulp 1.0
 */
function pulp_body_classes( $classes ) {

	if ( ! is_multi_author() ) {
		$classes[] = 'single-author';
	}

	if ( is_singular() && ! is_home() && ! is_page_template( 'showcase.php' ) && ! is_page_template( 'sidebar-page.php' ) )
		$classes[] = 'singular';

	return $classes;
}
add_filter( 'body_class', 'pulp_body_classes' );



function dtbaker_is_valid_email($email)
{
    return eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$", $email);
}

add_filter('wp_list_categories','dtbaker_wp_list_categories_adjust',10,2);
function dtbaker_wp_list_categories_adjust($cats, $args){
    return preg_replace('#</a>\s*\(([^\)]*)\)#',' </a><span class="number">$1</span>',$cats);
}
if ( ! isset( $content_width ) ) $content_width = 900;

// todo -only if jigoshop is installed.
//include('functions.jigoshop.php');
include('dtbaker.widgets.php');
include('dtbaker.theme_options.php');
include('dtbaker.shortcodes.php');
include('dtbaker.fonts.php');
include('dtbaker.theme_update.php');
if(class_exists('WooCommerce',false)){
    include('dtbaker.woocommerce.php');
}
include('dtbaker.gallery.php');
include('dtbaker.plugins.php');