<?php


?><!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>
<head profile="http://gmpg.org/xfn/11">

	<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
    <?php
    if(get_theme_mod('responsive_enabled',1)){ ?>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <?php } ?>
	<title><?php
        /*
       * Print the <title> tag based on what is being viewed.
       */
        global $page, $paged;

        wp_title( '|', true, 'right' );

        // Add the blog name.
        bloginfo( 'name' );

        // Add the blog description for the home/front page.
        $site_description = get_bloginfo( 'description', 'display' );
        if ( $site_description && ( is_home() || is_front_page() ) )
            echo " | $site_description";

        // Add a page number if necessary:
        if ( $paged >= 2 || $page >= 2 )
            echo ' | ' . sprintf( __( 'Page %s', 'pulp' ), max( $paged, $page ) );

        ?></title>

    <link rel="profile" href="http://gmpg.org/xfn/11" />
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

    <?php



    wp_head();

    ?>

</head>
<body <?php body_class(); ?>>
<div id="holder">
    <div id="wrapper">
        <div id="pulp_bg"></div>
    <!-- start header area / logo/ menu -->
      <div id="header">
        <div id="logo">
            <a href="<?php echo get_theme_mod('home'); ?>/"><?php
            // either image or text.
            $image_url = get_theme_mod('logo_header_image', get_template_directory_uri().'/images/logo.png');
            $logo_text = get_theme_mod('logo_header_text', 'Pulp');
            if($image_url){
                $image = '<img id="site-logo" src="%s" alt="%s" border="0" style="width:%spx">';
                printf(
                    $image,
                    $image_url,
                    get_bloginfo('name'),
                    get_theme_mod('logo_header_image_width', '135')
                );
            }else{
                echo $logo_text;
            }
            ?></a>
        </div>
          <div id="menu_spacer"></div>
        <div id="menu_wrap">
            <div id="menu_container">
                <div id="menu_container_decal">
                    <?php if(get_theme_mod('header_show_decal',1)){ ?>
                    <div id="menu_decal">
                        <!-- used to display the clouds and sun over the menu -->
                        <div><div><div></div></div></div>
                    </div>
                    <?php } ?>
                    <?php
                    wp_nav_menu(  array( 'theme_location' => 'primary' ));
                    ?>
                    <div class="clear"></div>
                </div>
            </div>

        </div>
        <div class="clear"></div>
    </div>
    <!-- end header -->
    <?php
    // call the sidebar manager widget:
    // "content_full" shows a widget area that spans the complete width of the page.
    do_action('widget_area_manager_hook','content_full_page');
    ?>

        <div id="inner_content">
        <?php
        // "before content" starts the <div> tags to display the main content with an optional sidebar.
        do_action('widget_area_manager_hook','content_top');
        ?>
