

pulp = {
    squirrel_animate_once: false, // change to false to animate at each page load.

    init: function(){
        jQuery("#menu_container  ul.menu > li:last-child").addClass('last-child');
        if(typeof pulp_params != 'undefined'){
            if(typeof pulp_params.do_animate_sun != 'undefined' && pulp_params.do_animate_sun){
                this.animate_sun();
            }
            if(typeof pulp_params.backgrounds != 'undefined' && pulp_params.backgrounds.length > 0){
                for (var i=0;i<pulp_params.backgrounds.length;i++){
                    // do we animate the backgrounds
                    jQuery('#pulp_bg').append('<div class="pulp_bg_item" style="background-image: url('+pulp_params.backgrounds[i][0]+'); width: '+pulp_params.backgrounds[i][3]+'px;  height: '+pulp_params.backgrounds[i][4]+'px; margin-right: '+(0-pulp_params.backgrounds[i][2]-pulp_params.backgrounds[i][3])+'px; margin-top: '+pulp_params.backgrounds[i][1]+'px; "></div>');
                }
                jQuery('#pulp_bg').delegate('.pulp_bg_item','mouseover',function(){
                    jQuery(this).stop().animate({
                        'padding-top':0
                    },200);
                }).delegate('.pulp_bg_item','mouseout',function(){
                    jQuery(this).stop().animate({
                        'padding-top':10
                    },200);
                })
            }
            //this.animate_footer();
        }
    },
    animate_sun: function(){
        jQuery('#menu_decal > div > div').css('background-position','0 88px').css('border-spacing','88px').animate(
            {'border-spacing': 0},
            {
                step: function(now, fx) { jQuery(fx.elem).css("background-position", "0 "+now+"px"); },
                duration: 600
            }
        ).hover(function(){
                jQuery(this).stop().animate(
                    {'border-spacing': 88},
                    {
                        step: function(now, fx) { jQuery(fx.elem).css("background-position", "0 "+now+"px"); },
                        duration: 200
                    }
                );
            },function(){
                jQuery(this).stop().animate(
                    {'border-spacing': 0},
                    {
                        step: function(now, fx) { jQuery(fx.elem).css("background-position", "0 "+now+"px"); },
                        duration: 200
                    }
                );
            });
    },
    isScrolledIntoView: function(elem){
        var docViewTop = jQuery(window).scrollTop();
        var docViewBottom = docViewTop + jQuery(window).height();
        var elemTop = elem.offset().top;
        return ((elemTop <= docViewBottom) && (elemTop >= docViewTop));
    },
    squirrel_done: false,
    squirrel_done_callback: function(a, s, t){
        var rotate = true;
        s.animateRotate(a, 0, 80);
        s.hover(function(){
            s.animateRotate(0, 10, 50);
        }, function(){
            s.animateRotate(10, 0, 50);
        });
        //setTimeout(function(){
        s.click(function(){
            // run the squirrel out of view and set a cookie so it runs back in.
            t.setCookie("squirrel_done_check","click");// set 2 so it runs in again at next page load
            s.stop().animate({
                left: jQuery(window).width() * -1
            },{
                duration: 2000,
                progress: function(){
                    if(rotate){
                        rotate = false;
                        var newa = a>0 ? 0 : 15;
                        s.animateRotate(a, newa, 80, 'swing', function(){
                            a = newa;
                            rotate = true;
                        });
                    }
                },
                complete: function(){
                    s.hide();
                }
            });

        });
        t.animate_footer_bird(true, true);
    },
    squirrel_animate: function(s,t){
        if(!t.squirrel_done){
            if(t.isScrolledIntoView(s)){
                // animate the squirrel from right (1300px) to left (200px) jumping along the way.
                t.squirrel_done = true;
                t.setCookie("squirrel_done_check","yes");
                // todo - read 980 from window width settings.
                s.css('left',(jQuery(window).width()/2) + (980 / 2) + 'px');
                s.show();
                var rotate = true, a = 0;
                s.stop().animate({
                    left: 200
                },{
                    duration: 2000,
                    progress: function(){
                        if(rotate){
                            rotate = false;
                            var newa = a>0 ? 0 : 15;
                            s.animateRotate(a, newa, 80, 'swing', function(){
                                a = newa;
                                rotate = true;
                            });
                        }
                    },
                    complete: function(){
                        t.squirrel_done_callback(a, s, t);
                    }
                });
                //s.animateRotate(0, 10, 100);
            }
        }
    },
    animate_footer: function(){
        var s = jQuery('#footer_decal_squirrel');
        var t = this;
        if(t.squirrel_animate_once && t.getCookie("squirrel_done_check") == "yes"){
            t.squirrel_done = true;
            t.squirrel_done_callback(0, s, t);
        }else{
            s.hide();
            jQuery(window).scroll(function(){t.squirrel_animate(s,t);});
            t.squirrel_animate(s,t);
            }

        // animate the clouds and stuff when mouse moves left/right
        // roughly based off: http://www.egstudio.biz/easy-parallax-with-jquery/
        var height = jQuery(window).height();
        var width = jQuery(window).width();
        var animate_objects=[
            {
                object: jQuery('#footer_decal_clouds'),
                strength: [5, 10, 20, 5] // 4 bg images on this div, support 4 different strenghts for each one.
            },
            {
                object: jQuery('#footer_decal_mountains'),
                strength: 6
            }
        ];
        jQuery('body').bind('mousemove2',function(e){
            var pageX = e.pageX - (jQuery(window).width() / 2);
            var pageY = e.pageY - (jQuery(window).height() / 2);
            for(var i = 0; i < animate_objects.length; i++){
                // we get current background positions and modify them based on that
                if(typeof animate_objects[i].origin == 'undefined'){
                    var o = animate_objects[i].object.css('background-position').split(',');
                    for(var oi = 0; oi< o.length; oi++){
                        o[oi] = jQuery.trim(o[oi]).split(' ');
                        o[oi][0] = parseInt(o[oi][0]);
                        o[oi][1] = parseInt(o[oi][1]);
                    }
                    animate_objects[i].origin = o;
                }
                if(animate_objects[i].origin.length > 0){
                    var bg = "";
                    for(var oi = 0; oi < animate_objects[i].origin.length; oi++){
                        if(bg.length > 0){
                            bg = bg + ", ";
                        }
                        var strength = typeof animate_objects[i].strength == 'object' ? animate_objects[i].strength[oi] : animate_objects[i].strength;
                        bg += (animate_objects[i].origin[oi][0] + ((strength / width) * pageX) * -1);
                        bg += "px ";
                        bg += (animate_objects[i].origin[oi][1] + ((strength / height) * pageY) * -1);
                        bg += "px ";
                    }
                    animate_objects[i].object.css("background-position", bg);
                }
            }
        });
    },
    animate_footer_bird: function(repeat, init){
        var b = jQuery('#footer_decal_bird'), t = this;
        if(init){
            b.on('mouseenter',function(){t.animate_footer_bird(false,false)});
        }
        b.animateRotate(0, -15, 80, 'swing', function(){
            b.animateRotate(-15, 0, 80);
            b.animateRotate(0, -15, 80, 'swing', function(){
                b.animateRotate(-15, 0, 80);
            });
        });
        if(repeat){
            setTimeout(function(){t.animate_footer_bird(true, false);},5000);
        }
    },
    getCookie: function(c_name) {
        var c_value = document.cookie;
        var c_start = c_value.indexOf(" " + c_name + "=");
        if (c_start == -1)
        {
        c_start = c_value.indexOf(c_name + "=");
        }
        if (c_start == -1)
        {
        c_value = null;
        }
        else
        {
        c_start = c_value.indexOf("=", c_start) + 1;
        var c_end = c_value.indexOf(";", c_start);
        if (c_end == -1)
        {
        c_end = c_value.length;
        }
        c_value = unescape(c_value.substring(c_start,c_end));
        }
        return c_value;
    },
    setCookie: function(c_name,value,exdays) {
        var exdate=new Date();
        exdate.setDate(exdate.getDate() + exdays);
        var c_value=escape(value) + ((exdays==null) ? "" : "; expires="+exdate.toUTCString());
        document.cookie=c_name + "=" + c_value;
    }
};

jQuery.fn.animateRotate = function(startAngle, angle, duration, easing, complete) {
    var args = jQuery.speed(duration, easing, complete);
    var step = args.step;
    return this.each(function(i, e) {
        args.step = function(now) {
            jQuery.style(e, 'transform', 'rotate(' + now + 'deg)');
            if (step) return step.apply(this, arguments);
        };

        jQuery({deg: startAngle}).animate({deg: angle}, args);
    });
};

jQuery(function(){
    pulp.init();
    // the sun animation at the top
});

window.onload = function(){
    setTimeout(function(){pulp.animate_footer();},500);
    // fix sidebar height if needed.
    if(jQuery('#inner_content').height() && jQuery('#inner_content').height() < jQuery('#inner_container').height()){
        jQuery('#inner_content').css('min-height',jQuery('#inner_container').height());
    }
};