<?php


function dtbaker_shortcode_fancy_posts($atts, $innercontent='', $code='') {
    extract(shortcode_atts(array(
        'id' => false,
        'category' => false,
        'max' => 4,
    ), $atts));
    // query wordpress for posts in this category.
    $query = query_posts( 'category_name='.$category.'&posts_per_page='.$max );
    ob_start();
    ?>
<div class="fancy_posts">
    <?php if ( have_posts() ) :
    while ( have_posts() ) : the_post();
        ?>
        <div id="post-<?php the_ID(); ?>" <?php post_class('blog fancy_post'); ?>>
            <div class="fancy_border">
                <div class="blog_date">
                    <span class="day"><?php echo get_the_date('jS');?></span>
                    <span class="month"><?php echo get_the_date('M');?></span>
                    <span class="year"><?php echo get_the_date('Y');?></span>
                </div>
                <?php if ( has_post_thumbnail() ) { ?>
                    <div class="blog_image">
                        <a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'pulp' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark">
                            <?php
                            if ( has_post_thumbnail() ) {
                                the_post_thumbnail( );
                            }
                            ?>
                        </a>
                    </div>
                <?php } ?>
                <div class="blog_header">
                    <h2 class="entry-title <?php echo ( is_sticky() ) ? ' featured-post' : '';?> ?>"><span><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'pulp' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a></span></h2>
                </div>
                <div class="blog_summary">
                    <?php
                    //the_excerpt();
                    echo wp_html_excerpt(get_the_excerpt(),170).' [...]';
                    ?>
                </div>
                <?php if ( 'post' == get_post_type() ) : ?>
                <div class="blog_footer">
                    <ul>
                        <li>
                            <a href="<?php the_permalink();?>"><?php _e('Read More','pulp');?></a>
                        </li>
                    </ul>
                    <div class="clear"></div>
                </div>

                <?php endif; ?>
            </div>
        </div>
        <?php
    endwhile;
else :
    echo wpautop( 'Sorry, no posts were found' );
endif; ?>
</div>
    <div class="clear"></div>
    <script type="text/javascript">
        jQuery(function(){
            jQuery('.fancy_post')
        });
    </script>
<?php
    wp_reset_query();
    return ob_get_clean();
}

add_shortcode('fancy_posts', 'dtbaker_shortcode_fancy_posts');

?>