<?php


function dtbaker_shortcode_google_map($atts, $innercontent='', $code='') {
    extract(shortcode_atts(array(
        'address' => 'Gold Coast, Australia',
        'enlarge_button' => 1,
        'height' => 400,
    ), $atts));
    ob_start();
?>

<div>
    <div id="googlemap" class="googlemap" style="height:<?php echo $height;?>px;"></div>
    <div class="clear"></div>
    <?php if($enlarge_button){ ?>
    <div class="map_buttons">
        <a href="#" onclick="return enlarge_map()"><?php _e('Enlarge Map','pulp');?></a>
    </div>
    <?php } ?>


</div>
<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=false"></script>
<script type="text/javascript">
    var geocoder;
    var map;
    var query = "<?php echo addcslashes($address,'"');?>";
    function enlarge_map(){
        window.open('http://maps.google.com.au/maps?q='+escape(query));
        return false;
    }
    function initialize() {
        geocoder = new google.maps.Geocoder();
        var myOptions = {
            zoom: 11,
            mapTypeId: google.maps.MapTypeId.ROADMAP
        }
        map = new google.maps.Map(document.getElementById("googlemap"), myOptions);
        codeAddress();
    }

    function codeAddress() {
        var address = query;
        geocoder.geocode( { 'address': address}, function(results, status) {
            if (status == google.maps.GeocoderStatus.OK) {
                map.setCenter(results[0].geometry.location);
                var infowindow = new google.maps.InfoWindow({
                    content: unescape("<?php echo str_replace('+',' ',(preg_replace('/\s+/',' ',addcslashes($innercontent,'"'))));?>")
                });
                var marker = new google.maps.Marker({
                    map: map,
                    position: results[0].geometry.location
                });
                google.maps.event.addListener(marker, 'click', function() {
                    infowindow.open(map,marker);
                });
                infowindow.open(map,marker);
            } else {
                alert("Geocode was not successful for the following reason: " + status);
            }
        });
    }
    jQuery(function(){
        initialize();
    });
</script>
<?php
    return ob_get_clean();

}

add_shortcode('google_map', 'dtbaker_shortcode_google_map');

?>