<?php
global $wp_query;

if(isset($_REQUEST['dtbaker_fbtab_action'])){
    switch($_REQUEST['dtbaker_fbtab_action']){
        case 'save':
            $tab_id = (int)$_REQUEST['dtbaker_fbtab_id'];
            update_option('dtbaker_fbtab'.$tab_id.'_app_id',$_REQUEST['app_id']);
            update_option('dtbaker_fbtab'.$tab_id.'_app_secret',$_REQUEST['app_secret']);
            update_option('dtbaker_fbtab'.$tab_id.'_product_cat',$_REQUEST['product_cat']);
            break;
    }
}
?>
<div class="wrap woocommerce">
    <h2><?php _e('Facebook Tab','woocommerce-facebook-tab');?></h2>
    <p>
        <strong><?php _e('How to setup Facebook tabs for WooCommerce products:','woocommerce-facebook-tab');?></strong>
    </p>
    <form action="" method="post">
        <?php $tab_id=1;?>
        <input type="hidden" name="dtbaker_fbtab_id" value="<?php echo $tab_id;?>">
        <input type="hidden" name="dtbaker_fbtab_action" value="save">
        <ol>
            <?php if(!is_ssl()){ ?>
            <li><?php _e('<strong>IMPORTANT: </strong> SSL Security must be enabled for Facebook integration. Please talk with your hosting provider to setup SSL on this wordpress blog. To check if you have SSL please change "http://" to "https://" in your address bar and see if it wordpress loads without errors.','woocommerce-facebook-tab');?> </li>
            <?php } ?>
            <li><?php _e('Signup for a Facebook account if you don\'t already have one.','woocommerce-facebook-tab');?></li>
            <li><?php _e('Create a Facebook page for your business if you don\'t already have one (<a href="https://www.facebook.com/pages/create.php">click here for help</a>)','woocommerce-facebook-tab');?></li>
            <li><?php _e('Visit the <a href="https://developers.facebook.com/apps">Facebook Developer App</a>. If you haven\'t created an application before you will be prompted to add the Developer Application (ie: Press Allow)','woocommerce-facebook-tab');?></li>
            <li><?php _e('Click the "Create New App" button','woocommerce-facebook-tab');?></li>
            <li><?php _e('In the "App Display Name:" box enter your website name (eg: Bobs Online Gift Shop)','woocommerce-facebook-tab');?></li>
            <li><?php printf(__('In the "App Domain:" box enter your domain name (eg: %s)','woocommerce-facebook-tab'), $_SERVER["HTTP_HOST"]);?></li>
            <li><?php _e('You can leave "App Namespace:" box empty.','woocommerce-facebook-tab');?></li>
            <li><?php _e('Click create.','woocommerce-facebook-tab');?></li>
            <li><?php _e('(optional) Now change the icon of your application to match your websites icon or business logo.','woocommerce-facebook-tab');?></li>
            <li><?php _e('Go to the "Select how your app integrates with Facebook" section, and choose the "Page Tab" option.','woocommerce-facebook-tab');?></li>
            <li><?php _e('In the "Page Tab Name:" box enter a short name that will display to users (eg: Online Shop, Our Products)','woocommerce-facebook-tab');?></li>
            <li>In the "Page Tab URL:" box enter this special URL: <strong><?php echo preg_replace('#^https#','http',site_url('?post_type=product&'._WC_FB_TAB_KEY));?></strong></li>
            <li>In the "Secure Page Tab URL:" box enter this special URL: <strong><?php echo site_url('?post_type=product&'._WC_FB_TAB_KEY, 'https');?></strong></li>
            <li>In the "Page Tab Edit URL:" box enter this special URL: <strong><?php echo admin_url();?>admin.php?page=woocommerce_facebook</strong></li>
            <li><?php _e('Click the Save Button.','woocommerce-facebook-tab');?></li>
            <li><?php _e('Your settings should now look similar to this:','woocommerce-facebook-tab');?>
                <br/>
                <a href="<?php echo plugins_url('setup.jpg',__FILE__);?>"><img src="<?php echo plugins_url('setup.jpg',__FILE__);?>" width="400"></a>
            </li>
            <li><?php _e('At the top of your Facebook page you will see the "App ID" and "App Secret" long numbers, please enter them below:','woocommerce-facebook-tab');?></li>
            <li><?php _e('Enter your APP ID:','woocommerce-facebook-tab');?>
                <input type="text" name="app_id" value="<?php echo esc_attr(get_option('dtbaker_fbtab'.$tab_id.'_app_id',''));?>" size="100">
            </li>
            <li><?php _e('Enter your APP Secret:','woocommerce-facebook-tab');?>
                <input type="text" name="app_secret" value="<?php echo esc_attr(get_option('dtbaker_fbtab'.$tab_id.'_app_secret',''));?>" size="100">
            </li>
            <li><?php _e('Once you have entered the above settings please click this save button:','woocommerce-facebook-tab');?>
                <input type="submit" name="save" value="Save Facebook Settings">
            </li>
            <li>
                <?php _e('When you have entered the above settings, and pressed the save button, and are ready to add this to your Facebook Page','woocommerce-facebook-tab');?> <a href="https://www.facebook.com/dialog/pagetab?app_id=<?php echo esc_attr(get_option('dtbaker_fbtab'.$tab_id.'_app_id',''));?>&next=<?php echo urlencode(site_url().'/?'._WC_FB_TAB_KEY);?>"><?php _e('please click here','woocommerce-facebook-tab');?></a> <?php _e('to continue','woocommerce-facebook-tab');?>.
            </li>
        </ol>
    </form>

    <h2><?php _e('Customisation','woocommerce-facebook-tab');?></h2>

    <p>Please feel free to customise the Facebook Tab layout by copying these <strong>default plugin template files</strong> from the plugin folder into your <strong>main theme directory</strong> (<?php echo get_stylesheet_directory();?>) and then customising them:</p>
    <ul>
        <li><?php echo 'plugins/woocommerce-facebook/templates/woocommerce-facebook-archive.php';?></li>
        <li><?php echo'plugins/woocommerce-facebook/templates/woocommerce-facebook-breadcrumb.php';?></li>
        <li><?php echo 'plugins/woocommerce-facebook/templates/woocommerce-facebook-cart.php';?></li>
        <li><?php echo 'plugins/woocommerce-facebook/templates/woocommerce-facebook-footer.php';?></li>
        <li><?php echo 'plugins/woocommerce-facebook/templates/woocommerce-facebook-header.php';?></li>
        <li><?php echo 'plugins/woocommerce-facebook/templates/woocommerce-facebook-single.php';?></li>
    </ul>
    <p>Please feel free to create a CSS file called <strong>woocommerce-facebook.css</strong> in your main theme directory and this will be loaded on the facebook tabs. By creating this file you can overwrite the default layout styles to match your needs.</p>

</div>